package me.illia.robotmod.actions;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import me.illia.robotmod.entity.RobotEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_234;
import net.minecraft.class_236;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import java.util.List;

public record ExecuteActionCallback(int eid, int actionI, class_5321<class_1937> world) implements class_234<MinecraftServer> {
	public static final MapCodec<ExecuteActionCallback> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group(
		Codec.INT.fieldOf("eid").forGetter(ExecuteActionCallback::eid),
		Codec.INT.fieldOf("actionI").forGetter(ExecuteActionCallback::actionI),
		class_1937.field_25178.fieldOf("world").forGetter(ExecuteActionCallback::world)
	).apply(inst, ExecuteActionCallback::new));

	@Override
	public void call(MinecraftServer server, class_236<MinecraftServer> events, long time) {
		var worldInstance = server.method_3847(world);
		if (worldInstance == null) return; // world not loaded

		class_1297 entity = worldInstance.method_8469(eid);
		if (!(entity instanceof RobotEntity robot)) return; // not a robot

		List<Action> actions = robot.actions;
		if (actionI < 0 || actionI >= actions.size()) return; // invalid index

		List<Action> remaining = actions.subList(actionI, actions.size());

		for (int i = 0; i < remaining.size(); i++) {
			Action action = remaining.get(i);
			ActionRunner.run(action, robot, i);
		}
	}

	//? if >1.21.3 {
	@Override
	public MapCodec<? extends ExecuteActionCallback> method_67704() {
		return CODEC;
	}
	//? }
}
