package me.illia.robotmod.actions.action;

import me.illia.robotmod.Util;
import me.illia.robotmod.actions.Action;
import me.illia.robotmod.actions.ActionParamDescriptor;
import me.illia.robotmod.actions.ActionParamType;
import me.illia.robotmod.actions.CustomAction;
import me.illia.robotmod.entity.RobotEntity;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2404;
import net.minecraft.class_2561;
import net.minecraft.class_3965;
import java.util.List;

public class BreakBlockAction extends CustomAction {
	@Override
	public void run(RobotEntity robot) {
		ActionParamDescriptor breakFluidDesc = paramDescriptors().get(0);
		Action.ParamValue breakFluidVal = params.get(Util.key(breakFluidDesc.name()));
		boolean breakFluid;
		if (breakFluidVal instanceof Action.ParamValue.BoolParam(boolean value)) {
			breakFluid = value;
		} else {
			throw new RuntimeException("break fluid isn't bool for some reason, instead it's " + breakFluidVal.type());
		}

		class_239 res = robot.method_5745(5, 1.0F, breakFluid);
		if (res instanceof class_3965 blockHit) {
			class_2338 pos = blockHit.method_17777();

			// TODO: implement block breaking progress using setBlockBreakingInfo

			class_1937 world = Util.entityWorld(robot);
			if (world.method_8320(blockHit.method_17777()).method_26204() instanceof class_2404 && breakFluid) {
				world.method_8501(pos, class_2246.field_10124.method_9564());
			} else {
				world.method_22352(pos, true);
			}
		}
	}

	@Override
	public List<ActionParamDescriptor> paramDescriptors() {
		return List.of(new ActionParamDescriptor(class_2561.method_43471("menu.robotmod.action_param_break_fluid"), ActionParamType.Bool));
	}

	@Override
	public String translation() {
		return "menu.robotmod.action_type_break_block";
	}
}
