package me.illia.robotmod.actions.action;

import me.illia.robotmod.Robotmod;
import me.illia.robotmod.Util;
import me.illia.robotmod.actions.ActionParamDescriptor;
import me.illia.robotmod.actions.CustomAction;
import me.illia.robotmod.entity.RobotEntity;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_3218;
import java.util.Comparator;
import java.util.List;

public class HitNearestEntityAction extends CustomAction {
	public static final double HIT_RADIUS = 8;

	@Override
	public void run(RobotEntity robot) {
		class_1937 world = Util.entityWorld(robot);

		class_238 box = new class_238(
			robot.method_23317() - HIT_RADIUS, robot.method_23318() - HIT_RADIUS, robot.method_23321() - HIT_RADIUS,
			robot.method_23317() + HIT_RADIUS, robot.method_23318() + HIT_RADIUS, robot.method_23321() + HIT_RADIUS
		);

		List<class_1297> entities = world.method_8390(class_1297.class, box, e -> !e.equals(robot));

		class_1297 nearest = entities.stream()
			.filter(e -> e.method_5858(robot) <= HIT_RADIUS * HIT_RADIUS)
			.min(Comparator.comparingDouble(e -> e.method_5858(robot)))
			.orElse(null);

		if (nearest != null) {
			// casting to server world is acceptable because actions only get ran on server
			robot.method_6121((class_3218)world, nearest);
		}
	}

	@Override
	public List<ActionParamDescriptor> paramDescriptors() {
		return List.of();
	}

	@Override
	public String translation() {
		return "menu.robotmod.action_type_hit_nearest_entity";
	}
}
