package me.illia.robotmod.actions.action;

import me.illia.robotmod.Util;
import me.illia.robotmod.actions.Action;
import me.illia.robotmod.actions.ActionParamDescriptor;
import me.illia.robotmod.actions.ActionParamType;
import me.illia.robotmod.actions.CustomAction;
import me.illia.robotmod.entity.RobotEntity;
import me.illia.robotmod.networking.RobotEntityUpdateHeadRotationS2CPayload;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import java.util.List;

public class SetYawAction extends CustomAction {
	@Override
	public void run(RobotEntity robot) {
		ActionParamDescriptor yawParamDesc = paramDescriptors().get(0);
		Action.ParamValue yawVal = params.get(Util.key(yawParamDesc.name()));
		float yaw;
		if (yawVal instanceof Action.ParamValue.FloatParam(float value)) {
			yaw = value;
		} else {
			throw new RuntimeException("yaw isn't float for some reason, instead it's " + yawVal.type());
		}

		robot.method_36456(yaw);
		((class_3218)Util.entityWorld(robot)).method_14178().field_17254.method_37907(robot.method_31476()).forEach((serverPlayerEntity -> {
			ServerPlayNetworking.send(serverPlayerEntity, new RobotEntityUpdateHeadRotationS2CPayload(robot.method_5628(), yaw, robot.method_36455()));
		}));
	}

	@Override
	public List<ActionParamDescriptor> paramDescriptors() {
		return List.of(new ActionParamDescriptor(class_2561.method_43471("menu.robotmod.action_param_yaw"), ActionParamType.Float));
	}

	@Override
	public String translation() {
		return "menu.robotmod.action_type_set_yaw";
	}
}
