package me.illia.robotmod.actions.action;

import me.illia.robotmod.Util;
import me.illia.robotmod.actions.*;
import me.illia.robotmod.entity.RobotEntity;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import java.util.List;

public class WalkAction extends CustomAction {
	@Override
	public void run(RobotEntity robot) {
		ActionParamDescriptor walkParamDesc = paramDescriptors().get(0);
		Action.ParamValue walkVal = params.get(Util.key(walkParamDesc.name()));
		Direction dir;
		if (walkVal instanceof Action.ParamValue.DirParam(Direction dirValue)) {
			dir = dirValue;
		} else {
			throw new RuntimeException("param isn't dir for some reason, instead it's " + walkVal.type());
		}

		ActionParamDescriptor blocksParamDesc = paramDescriptors().get(1);
		Action.ParamValue blocksVal = params.get(Util.key(blocksParamDesc.name()));
		float blocks;
		if (blocksVal instanceof Action.ParamValue.FloatParam(float blocksValue)) {
			blocks = blocksValue;
		} else {
			throw new RuntimeException("block amount isn't float for some reason, instead it's " + blocksVal.type());
		}

		net.minecraft.class_2350 mcDir = switch (dir) {
			case North -> net.minecraft.class_2350.field_11043;
			case East -> net.minecraft.class_2350.field_11034;
			case South -> net.minecraft.class_2350.field_11035;
			case West -> net.minecraft.class_2350.field_11039;
		};

		class_243 pos = robot.method_24515().method_46558().method_43206(mcDir, blocks);
		robot.method_5942().method_6337(pos.method_10216(), pos.method_10214(), pos.method_10215(), 1.0f);
	}

	@Override
	public List<ActionParamDescriptor> paramDescriptors() {
		return List.of(new ActionParamDescriptor(class_2561.method_43471("menu.robotmod.action_param_walk_to"), ActionParamType.Dir), new ActionParamDescriptor(class_2561.method_43471("menu.robotmod.action_param_walk_blocks"), ActionParamType.Float));
	}

	@Override
	public String translation() {
		return "menu.robotmod.action_type_walk";
	}
}
