package me.illia.robotmod.actions.action;

import me.illia.robotmod.Util;
import me.illia.robotmod.actions.Action;
import me.illia.robotmod.actions.ActionParamDescriptor;
import me.illia.robotmod.actions.ActionParamType;
import me.illia.robotmod.actions.CustomAction;
import me.illia.robotmod.block.LunarPanelBlock;
import me.illia.robotmod.block.ModBlocks;
import me.illia.robotmod.entity.RobotEntity;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class WalkAroundAction extends CustomAction {
	@Override
	public void run(RobotEntity robot) {
		ActionParamDescriptor radiusParamDesc = paramDescriptors().get(0);
		Action.ParamValue val = params.get(Util.key(radiusParamDesc.name()));
		int r;
		if (val instanceof Action.ParamValue.IntParam(int value)) {
			r = value;
		} else {
			throw new RuntimeException("radius isn't int for some reason, instead it's " + val.type());
		}

		class_1408 nav = robot.method_5942();

		class_2338 center = robot.method_24515();
		int segments = 72;
		double speed = 1.0;

		List<class_243> path = new ArrayList<>();
		for (int i = 0; i < segments; i++) {
			double angle = 2 * Math.PI * i / segments;
			double x = center.method_10263() + r * Math.sin(angle);
			double y = center.method_10264();
			double z = center.method_10260() + r * Math.cos(angle);
			path.add(new class_243(x, y, z));
		}
		path.add(new class_243(center.method_10263(), center.method_10264(), center.method_10260()));

		AtomicInteger index = new AtomicInteger(0);

		ServerTickEvents.START_SERVER_TICK.register((minecraftServer -> {
			if (Util.nearest(robot, 35, state -> state.method_27852(ModBlocks.LUNAR_PANEL_BLOCK) && state.method_11654(LunarPanelBlock.ACTIVE)) && index.get() < path.size()) {
				class_243 target = path.get(index.get());
				if (!nav.method_23966()) {
					nav.method_6337(target.field_1352, target.field_1351, target.field_1350, speed);
					index.incrementAndGet(); // next point
				}
			};
		}));
	}

	@Override
	public List<ActionParamDescriptor> paramDescriptors() {
		return List.of(new ActionParamDescriptor(class_2561.method_43471("menu.robotmod.action_param_walk_around"), ActionParamType.Int));
	}

	@Override
	public String translation() {
		return "menu.robotmod.action_type_walk_around";
	}
}
