package me.illia.robotmod.attachment;

import com.mojang.serialization.Codec;
import me.illia.robotmod.Robotmod;
import net.minecraft.class_2338;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public record TeleportPointAttachedData(List<TeleportPoint> points) {
	public static final Codec<TeleportPointAttachedData> CODEC = TeleportPoint.CODEC.listOf().xmap(TeleportPointAttachedData::new, TeleportPointAttachedData::points);
	public static TeleportPointAttachedData DEFAULT = new TeleportPointAttachedData(List.of());

	public TeleportPointAttachedData addPoint(TeleportPoint point) {
		ArrayList<TeleportPoint> points2 = new ArrayList<>(points);
		points2.add(point);
		return new TeleportPointAttachedData(List.copyOf(points2));
	}

	public TeleportPointAttachedData removePoint(TeleportPoint point) {
		if (!points.contains(point)) return this;

		ArrayList<TeleportPoint> points2 = new ArrayList<>(points);
		points2.removeIf(v -> v == point);

		return new TeleportPointAttachedData(points2);
	}

	public TeleportPointAttachedData removePointByPos(class_2338 pos) {
		Optional<TeleportPoint> found = findPointByPos(pos);
		if (found.isEmpty()) return this;

		ArrayList<TeleportPoint> points2 = new ArrayList<>(points);
		points2.removeIf(v -> v == found.get());

		return new TeleportPointAttachedData(points2);
	}

	public TeleportPointAttachedData clear() {
		return DEFAULT;
	}

	public Optional<TeleportPoint> findPointByPos(class_2338 pos) {
		return points.stream()
			.filter(element -> element.pos().equals(pos))
			.findFirst();
	}
}
