package me.illia.robotmod.block;

import me.illia.robotmod.attachment.ModAttachmentTypes;
import me.illia.robotmod.attachment.TeleportPoint;
import me.illia.robotmod.attachment.TeleportPointAttachedData;
import me.illia.robotmod.item.ModItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2482;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import java.util.function.UnaryOperator;

public class TeleporterBlock extends class_2482 {
	public static final class_2746 CHARGED = class_2746.method_11825("charged");
	public static final class_265 SHAPE = class_259.method_1081(0, 0, 0, 1, 0.4, 1);
	public TeleporterBlock(class_2251 settings) {
		super(settings);

		method_9590(method_9564().method_11657(CHARGED, false));
	}

	@SuppressWarnings("UnstableApiUsage")
	@Override
	public class_1269 method_55765(class_1799 stack, class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
		if (stack.method_7909() == ModItems.PACKED_ENDER_PEARL && !world.method_8608() && world instanceof class_3218 serverWorld) {
			TeleportPointAttachedData attachedData = serverWorld.getAttachedOrElse(ModAttachmentTypes.TELEPORT_POINTS, TeleportPointAttachedData.DEFAULT);
			if (attachedData.findPointByPos(pos).isPresent()) return class_1269.field_21466;

			serverWorld.method_8501(pos, state.method_11657(CHARGED, true));
			serverWorld.method_8396(player, pos, class_3417.field_14981, class_3419.field_15245, 1.0f, 0.3f);

			class_1799 stack2 = stack.method_7972();
			stack2.method_57008(1, player);

			player.method_6122(hand, stack2);

			serverWorld.setAttached(ModAttachmentTypes.TELEPORT_POINTS, attachedData.addPoint(new TeleportPoint("" + (attachedData.points().size() + 1), pos, world.method_27983())));

			return class_1269.field_21466;
		}
		return super.method_55765(stack, state, world, pos, player, hand, hit);
	}

	@SuppressWarnings("UnstableApiUsage")
	@Override
	public class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
		if (player.method_5998(player.method_6058()).method_7960() && world.method_8320(pos).method_11654(CHARGED)) {
			player.method_7270(new class_1799(ModItems.PACKED_ENDER_PEARL));
			world.method_8501(pos, state.method_11657(CHARGED, false));

			class_3218 serverWorld = (class_3218)world;
			TeleportPointAttachedData data = serverWorld.getAttachedOrCreate(ModAttachmentTypes.TELEPORT_POINTS);
			serverWorld.setAttached(ModAttachmentTypes.TELEPORT_POINTS, data.removePointByPos(pos));
		}

		return super.method_55766(state, world, pos, player, hit);
	}

	@Override
	protected class_265 method_9549(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		return SHAPE;
	}

	@Override
	protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
		return SHAPE;
	}

	@SuppressWarnings("UnstableApiUsage")
	@Override
	public class_2680 method_9576(class_1937 world, class_2338 pos, class_2680 state, class_1657 player) {
		if (!world.method_8608() && world instanceof class_3218 serverWorld) {
			TeleportPointAttachedData data = serverWorld.getAttachedOrCreate(ModAttachmentTypes.TELEPORT_POINTS);
			serverWorld.setAttached(ModAttachmentTypes.TELEPORT_POINTS, data.removePointByPos(pos));
		}
		return super.method_9576(world, pos, state, player);
	}

	@Override
	protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
		builder.method_11667(CHARGED);
		super.method_9515(builder);
	}
}
