package me.illia.robotmod.client;

import me.illia.robotmod.Util;
import me.illia.robotmod.entity.ModEntities;
import me.illia.robotmod.entity.RobotEntityModel;
import me.illia.robotmod.entity.RobotEntityRenderer;
import me.illia.robotmod.screen.ChooseTeleportScreen;
import me.illia.robotmod.screen.ModScreenHandlers;
import me.illia.robotmod.screen.RobotInventoryScreen;
import me.illia.robotmod.screen.RobotScreen;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.rendering.v1.EntityModelLayerRegistry;
import net.fabricmc.fabric.api.client.rendering.v1.EntityRendererRegistry;
import net.minecraft.class_3929;
import net.minecraft.class_5601;

public class RobotmodClient implements ClientModInitializer {

	public static final class_5601 MODEL_ROBOT_LAYER = new class_5601(Util.id("robot"), "main");

	@SuppressWarnings("deprecation")
	@Override
	public void onInitializeClient() {
		class_3929.method_17542(ModScreenHandlers.ROBOT_SCREEN_HANDLER, RobotScreen::new);
		class_3929.method_17542(ModScreenHandlers.ROBOT_INVENTORY_SCREEN_HANDLER, RobotInventoryScreen::new);
		class_3929.method_17542(ModScreenHandlers.CHOOSE_TELEPORT_SCREEN_HANDLER, ChooseTeleportScreen::new);

		// DEPRECATED, but i really dont wanna switch to vanilla's alternative
		EntityRendererRegistry.register(ModEntities.ROBOT, RobotEntityRenderer::new);

		EntityModelLayerRegistry.registerModelLayer(MODEL_ROBOT_LAYER, RobotEntityModel::getTexturedModelData);
	}
}
