package me.illia.robotmod.datagen;

import me.illia.robotmod.datagen.provider.ModEnUsProvider;
import me.illia.robotmod.datagen.provider.ModModelProvider;
import me.illia.robotmod.datagen.provider.ModRecipeProvider;
import me.illia.robotmod.datagen.provider.ModWorldProvider;
import net.fabricmc.fabric.api.datagen.v1.DataGeneratorEntrypoint;
import net.fabricmc.fabric.api.datagen.v1.FabricDataGenerator;
import net.minecraft.class_7877;

public class RobotmodDataGenerator implements DataGeneratorEntrypoint {
	@Override
	public void onInitializeDataGenerator(FabricDataGenerator fabricDataGenerator) {
		FabricDataGenerator.Pack pack = fabricDataGenerator.createPack();
		pack.addProvider(ModEnUsProvider::new);
		pack.addProvider(ModModelProvider::new);
		pack.addProvider(ModRecipeProvider::new);
		pack.addProvider(ModWorldProvider::new);
	}

	@Override
	public void buildRegistry(class_7877 registryBuilder) {
		DataGeneratorEntrypoint.super.buildRegistry(registryBuilder);
	}
}
