package me.illia.robotmod.datagen.provider;

import me.illia.robotmod.Util;
import me.illia.robotmod.actions.ModActionTypes;
import me.illia.robotmod.block.ModBlocks;
import me.illia.robotmod.entity.ModEntities;
import me.illia.robotmod.item.ModItems;
import me.illia.robotmod.registry.ModRegistries;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_7225;
import java.util.concurrent.CompletableFuture;

public class ModEnUsProvider extends FabricLanguageProvider {
	public ModEnUsProvider(FabricDataOutput dataOutput, CompletableFuture<class_7225.class_7874> registryLookup) {
		super(dataOutput, registryLookup);
	}

	@Override
	public void generateTranslations(class_7225.class_7874 wrapperLookup, TranslationBuilder b) {
		Util.add(b, "menu.robotmod.robot", "Robot");
		Util.add(b, "menu.robotmod.add", "+");
		Util.add(b, "menu.robotmod.no_points", "No Teleport Points!");

		Util.add(b, "menu.robotmod.action_type", "Type");

		Util.add(b, ModActionTypes.WALK, "Walk");
		Util.add(b, ModActionTypes.WALK_AROUND, "Walk Around");
		Util.add(b, ModActionTypes.HARVEST, "Harvest");
		Util.add(b, ModActionTypes.WAIT, "Wait");
		Util.add(b, ModActionTypes.HOME, "Home");
		Util.add(b, ModActionTypes.SWITCH_TO_SLOT, "Switch Slot");
		Util.add(b, ModActionTypes.SET_YAW, "Set Yaw");
		Util.add(b, ModActionTypes.SET_PITCH, "Set Pitch");
		Util.add(b, ModActionTypes.SET_HOME, "Set Home");
		Util.add(b, ModActionTypes.BREAK_BLOCK, "Break Block");
		Util.add(b, ModActionTypes.DROP, "Drop");
		Util.add(b, ModActionTypes.SAY, "Say");
		Util.add(b, ModActionTypes.HIT_NEAREST_ENTITY, "Hit Nearest Entity");
		Util.add(b, ModActionTypes.JUMP, "Jump");
		Util.add(b, ModActionTypes.USE, "Use");
		Util.add(b, ModActionTypes.REPEAT_LAST_ACTION, "Repeat Previous");
		Util.add(b, ModActionTypes.ATTACK, "Attack");


		Util.add(b, "menu.robotmod.action_param_walk_around", "around ");
		Util.add(b, "menu.robotmod.action_param_wait_sec", "for seconds");
		Util.add(b, "menu.robotmod.action_param_switch_slot", " to ");
		Util.add(b, "menu.robotmod.action_param_walk_to", " to ");
		Util.add(b, "menu.robotmod.action_param_walk_blocks", " for ");
		Util.add(b, "menu.robotmod.action_param_say", "text");
		Util.add(b, "menu.robotmod.action_param_yaw", " to ");
		Util.add(b, "menu.robotmod.action_param_pitch", " to ");
		Util.add(b, "menu.robotmod.action_param_break_fluid", "Break fluids?");
		Util.add(b, "menu.robotmod.teleported", "Teleported to %s");
		Util.add(b, "menu.robotmod.random", "Random");
		Util.add(b, "menu.robotmod.remove_last", "Remove Last");


		Util.add(b, "bool.robotmod.true", "True");
		Util.add(b, "bool.robotmod.false", "False");
		Util.add(b, "menu.robotmod.actions", "Actions");
		Util.add(b, "menu.robotmod.robot_inv", "Robot Inventory");
		Util.add(b, "direction.robotmod.north", "North");
		Util.add(b, "direction.robotmod.east", "East");
		Util.add(b, "direction.robotmod.south", "South");
		Util.add(b, "direction.robotmod.west", "West");
		Util.add(b, "itemGroup.robotmod.robotmod", "Technology");

		Util.add(b, ModItems.TELEPORTER, "Ender Teleporter");
		Util.add(b, ModItems.PACKED_ENDER_PEARL, "Packed Ender Pearl");
		Util.add(b, ModItems.ROBOT_SPAWN_EGG, "Robot Spawn Egg");
		Util.add(b, ModBlocks.TELEPORTER_BLOCK, "Ender Teleporter Block");
		Util.add(b, ModBlocks.LUNAR_PANEL_BLOCK, "Lunar Panel Block");
		Util.add(b, ModEntities.ROBOT, "Robot");
	}
}
