package me.illia.robotmod.entity;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import me.illia.robotmod.Robotmod;
import me.illia.robotmod.Util;
import me.illia.robotmod.actions.Action;
import me.illia.robotmod.actions.ActionRunner;
import me.illia.robotmod.block.LunarPanelBlock;
import me.illia.robotmod.block.ModBlocks;
import me.illia.robotmod.networking.RobotActionsSyncC2SPayload;
import me.illia.robotmod.screen.RobotInventoryScreenHandler;
import me.illia.robotmod.screen.RobotScreenHandler;
import me.illia.robotmod.screen.RobotScreenHandlerData;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.screenhandler.v1.ExtendedScreenHandlerFactory;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1306;
import net.minecraft.class_1314;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3738;
import net.minecraft.class_4095;
import net.tslat.smartbrainlib.api.SmartBrainOwner;
import net.tslat.smartbrainlib.api.core.BrainActivityGroup;
import net.tslat.smartbrainlib.api.core.SmartBrainProvider;
import net.tslat.smartbrainlib.api.core.behaviour.custom.look.LookAtTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.move.MoveToWalkTarget;
import net.tslat.smartbrainlib.api.core.behaviour.custom.target.SetPlayerLookTarget;
import net.tslat.smartbrainlib.api.core.sensor.ExtendedSensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.HurtBySensor;
import net.tslat.smartbrainlib.api.core.sensor.vanilla.NearbyLivingEntitySensor;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class RobotEntity extends class_1314 implements SmartBrainOwner<RobotEntity> {
	public ArrayList<Action> actions;
	public class_2338 home;
	public boolean ranActions;
	public class_1277 inv;
	public int slot;
	public int actionI = -1;

	public long waitStartTick = -1;
	public long waitEndTick = -1;
	public boolean waiting = false;

	public float headPitch = 0;

	public RobotEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
		super(entityType, world);

		this.actions = new ArrayList<>();
		this.inv = new class_1277(16);
		addListener();

		this.home = method_24515();
	}

	@Override
	public class_1799 method_61420(class_1306 arm) {
		if (arm == class_1306.field_6183) {
			return inv.method_5438(slot);
		}

		return super.method_61420(arm);
	}

	public void setHeadPitch(float headPitch) {
		this.headPitch = headPitch;
	}

	public float getHeadPitch() {
		return headPitch;
	}

	public void addListener() {
		inv.method_5489((inv) -> send(inv, null));
	}

	public void send(class_1263 inv, class_3222 entity) {
		class_1937 world = Util.entityWorld(this);
		if (!world.method_8608()) {
			class_1799 stack = inv.method_5438(slot);
			UpdateHeldItemS2CPayload payload = new UpdateHeldItemS2CPayload(method_5628(), stack);

			if (entity == null) {
				for (class_1657 player : ((class_3218)world).method_14178().field_17254.method_37907(method_31476())) {
					if (player instanceof class_3222 serverPlayerEntity) {
						ServerPlayNetworking.send(serverPlayerEntity, payload);
					}
				}
			} else {
				ServerPlayNetworking.send(entity, payload);
			}
		}
	}


	//? if >= 1.21.6 {
	@Override
	protected void method_5749(class_11368 view) {
		this.actions = new ArrayList<>(view.method_71426("actions", Action.CODEC.codec().listOf()).orElse(List.of()));
		this.home = view.method_71426("home", class_2338.field_25064).orElse(class_2338.field_10980);
		class_11368.class_11369<class_1799> invListView = view.method_71437("inv", class_1799.field_24671);
		inv.method_7659(invListView);
		this.slot = view.method_71424("slot", 0);

		this.waiting = view.method_71433("waiting", false);

		if (waiting) {
			waitStartTick = view.method_71425("waitStartTick", 0);
			waitStartTick = view.method_71425("waitEndTick", 0);
		}

		send(this.inv, null);

		super.method_5749(view);
	}

	@Override
	protected void method_5652(class_11372 view) {
		view.method_71468("actions", Action.CODEC.codec().listOf(), this.actions);
		view.method_71468("home", class_2338.field_25064, this.home);
		class_11372.class_11373<class_1799> invAppender = view.method_71467("inv", class_1799.field_24671);
		inv.method_7660(invAppender);

		view.method_71465("slot", this.slot);

		view.method_71472("waiting", waiting);
		if (waiting) {
			view.method_71466("waitStartTick", waitStartTick);
			view.method_71466("waitEndTick", waitEndTick);
		}

		super.method_5652(view);
	}

	//?} else {
	/*@Override
	public void readNbt(NbtCompound nbt) {
		super.readNbt(nbt);

		//? if 1.21.3 {
		/^this.slot = nbt.getInt("slot");

		this.waiting = nbt.getBoolean("waiting");

		if (waiting) {
			this.waitStartTick = nbt.getInt("waitStartTick");
			this.waitEndTick = nbt.getInt("waitEndTick");
		}
		^///? } else {
		this.slot = nbt.getInt("slot", 0);

		this.waiting = nbt.getBoolean("waiting", false);

		if (waiting) {
			this.waitStartTick = nbt.getInt("waitStartTick", 0);
			this.waitEndTick = nbt.getInt("waitEndTick", 0);
		}
		//? }

		if (nbt.contains("actions")) {
			this.actions = new ArrayList<>(
				Action.CODEC.codec().listOf()
					.parse(NbtOps.INSTANCE, nbt.get("actions"))
					.resultOrPartial(error -> Robotmod.LOGGER.error("Failed to read actions: {}", error))
					.orElse(List.of())
			);
		} else {
			this.actions = new ArrayList<>();
		}

		inv = new SimpleInventory(16);
		addListener();

		Inventories.readNbt(nbt, inv.heldStacks, getWorld().getRegistryManager());

		send(inv, null);
	}

	@Override
	public NbtCompound writeNbt(NbtCompound nbt) {
		super.writeNbt(nbt);

		nbt.putInt("slot", this.slot);

		Action.CODEC.codec().listOf()
			.encodeStart(NbtOps.INSTANCE, this.actions)
			.resultOrPartial(error -> Robotmod.LOGGER.error("Failed to write actions: {}", error))
			.ifPresent(nbtElement -> nbt.put("actions", nbtElement));

		Inventories.writeNbt(nbt, inv.heldStacks, getWorld().getRegistryManager());

		return nbt;
	}
	*///?}

	@Override
	public class_1799 method_6047() {
		return inv.method_5438(slot);
	}

	@Override
	protected class_1269 method_5992(class_1657 player, class_1268 hand) {
		class_1937 world = Util.entityWorld(this);
		if (world.method_8608()) return class_1269.field_5812;
		if (!player.method_5715() && !Util.night(world)) {
			player.method_17355(new ExtendedScreenHandlerFactory<RobotScreenHandlerData>() {
				private final int id = RobotEntity.this.method_5628();
				private final RobotScreenHandlerData robotScreenHandlerData = new RobotScreenHandlerData(id, RobotEntity.this.inv.field_5828);

				@Override
				public RobotScreenHandlerData getScreenOpeningData(class_3222 player) {
					return robotScreenHandlerData;
				}

				@Override
				public class_2561 method_5476() {
					return Util.t("menu.robotmod.robot");
				}

				@Override
				public RobotScreenHandler createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
					return new RobotScreenHandler(syncId, robotScreenHandlerData);
				}
			});
			return class_1269.field_52422;
		} else if (player.method_5715() && player.method_6047().method_7960()) {
			player.method_17355(new ExtendedScreenHandlerFactory<RobotScreenHandlerData>() {
				private final int id = RobotEntity.this.method_5628();
				private final RobotScreenHandlerData robotScreenHandlerData = new RobotScreenHandlerData(id, RobotEntity.this.inv.field_5828);

				@Override
				public RobotScreenHandlerData getScreenOpeningData(class_3222 serverPlayerEntity) {
					return robotScreenHandlerData;
				}

				@Override
				public class_2561 method_5476() {
					return Util.t("menu.robotmod.robot_inv");
				}

				@Override
				public RobotInventoryScreenHandler createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
					return new RobotInventoryScreenHandler(syncId, playerInventory, robotScreenHandlerData);
				}
			});
		}
		return class_1269.field_5811;
	}

	@Override
	protected class_4095.class_5303<?> method_28306() {
		return new SmartBrainProvider<>(this);
	}

	@Override
	protected void method_5958(class_3218 world) {
		tickBrain(this);

		boolean nearest = Util.nearest(this, 35, state -> state.method_27852(ModBlocks.LUNAR_PANEL_BLOCK) && state.method_11654(LunarPanelBlock.ACTIVE)) && Util.night(world);
		if (nearest) {
			if (!ranActions) {
				int i = 0;
				for (Action action : actions) {
					ActionRunner.run(action, this, i);
					actionI = i;

					List<class_3222> serverPlayers = world.method_18456();
					for (class_3222 serverPlayer : serverPlayers) {
						ServerPlayNetworking.send(serverPlayer, new UpdateActionDebugS2CPayload(actionI, method_5628()));
					}

					i++;
				}
				ranActions = true;
			}
		} else {
			ranActions = false;
			if (actionI != -1) {
				actionI = -1;

				List<class_3222> serverPlayers = world.method_18456();
				for (class_3222 serverPlayer : serverPlayers) {
					ServerPlayNetworking.send(serverPlayer, new UpdateActionDebugS2CPayload(actionI, method_5628()));
				}
			}
		}

		super.method_5958(world);
	}

	@Override
	public List<ExtendedSensor<RobotEntity>> getSensors() {
		return ObjectArrayList.of(
			new HurtBySensor<>(),
			new NearbyLivingEntitySensor<>()
		);
	}

	@Override
	public BrainActivityGroup<RobotEntity> getCoreTasks() {
		return BrainActivityGroup.coreTasks(
			new LookAtTarget<>(),
			new MoveToWalkTarget<>()
		);
	}

	@Override
	public BrainActivityGroup<RobotEntity> getIdleTasks() {
		return BrainActivityGroup.idleTasks(
			new SetPlayerLookTarget<>()
		);
	}

	@Override
	public boolean method_29503() {
		return true;
	}

	@Override
	public class_1306 method_6068() {
		return class_1306.field_6183;
	}

	public void save(ArrayList<Action> actions) {
		this.actions = actions;
		ClientPlayNetworking.send(new RobotActionsSyncC2SPayload(method_5628(), actions.stream().toList(), Util.entityWorld(this).method_27983()));
	}

	@Override
	public boolean method_5936() {
		return true;
	}

	@Override
	protected void method_5949(class_3218 world, class_1542 itemEntity) {
		class_1799 stack = itemEntity.method_6983();
		class_1799 leftover = inv.method_5491(stack.method_7972());
		if (leftover.method_7960()) {
			itemEntity.method_31472(); // remove the item if fully picked up
		} else {
			stack.method_7939(leftover.method_7947()); // leave remaining
		}
		super.method_5949(world, itemEntity);
	}

	@Override
	protected void method_16077(class_3218 world, class_1282 damageSource, boolean causedByPlayer) {
		int invI = 0;
		for (class_1799 stack : inv.field_5828) {
			if (invI != slot) {
				method_5775(world, stack);
			}

			invI++;
		}
		super.method_16077(world, damageSource, causedByPlayer);
	}

	@Override
	public void method_5837(class_3222 player) {
		class_1937 world = Util.entityWorld(this);
		world.method_8503().method_63588(new class_3738(1, () -> send(inv, player)));

		super.method_5837(player);
	}
}
