package me.illia.robotmod.networking;

import me.illia.robotmod.Robotmod;
import me.illia.robotmod.Util;
import me.illia.robotmod.attachment.ModAttachmentTypes;
import me.illia.robotmod.attachment.TeleportPointAttachedData;
import me.illia.robotmod.block.ModBlocks;
import me.illia.robotmod.block.TeleporterBlock;
import me.illia.robotmod.debug.DebugRenderers;
import me.illia.robotmod.entity.*;
import me.illia.robotmod.item.TeleporterItem;
import me.illia.robotmod.screen.ChooseTeleportScreen;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_897;
import net.minecraft.server.MinecraftServer;
import java.util.ArrayList;
import java.util.Set;

public class ModNetworking {
	@SuppressWarnings("UnstableApiUsage")
	public static void init() {
		ServerPlayNetworking.registerGlobalReceiver(RequestTeleportC2SPayload.ID, (requestTeleportC2SPayload, context) -> {
			class_2680 state = Util.entityWorld(context.player()).method_8320(requestTeleportC2SPayload.pos());
			if (state.method_26204() == ModBlocks.TELEPORTER_BLOCK && state.method_11654(TeleporterBlock.CHARGED) && context.player() instanceof class_3222) {
				context.server().execute(() -> {
					context.player().method_48105(context.server().method_3847(requestTeleportC2SPayload.world()), requestTeleportC2SPayload.pos().method_10263() + 0.5, requestTeleportC2SPayload.pos().method_10264() + 0.4, requestTeleportC2SPayload.pos().method_10260() + 0.5, Set.of(), 0, 0, true);
				});
			}
		});

		ServerPlayNetworking.registerGlobalReceiver(RobotActionsSyncC2SPayload.ID, ((robotActionsSyncC2SPayload, context) -> {
			MinecraftServer server = context.server();
			class_3218 world = server.method_3847(robotActionsSyncC2SPayload.world());
			if (world == null) {
				return;
			}

			class_1297 entity = world.method_8469(robotActionsSyncC2SPayload.eid());
			if (entity instanceof RobotEntity robot) {
				robot.save(new ArrayList<>(robotActionsSyncC2SPayload.actions()));
			}
		}));

		ClientPlayNetworking.registerGlobalReceiver(UpdateActionDebugS2CPayload.ID, ((((updateActionDebugS2CPayload, context) -> {
			class_310 client = context.client();
			//? if <1.21.10 {
			/*((DebugRenderers)client.debugRenderer).robotmod$getActionDebugRenderer().entities.stream().filter(e -> e.getId() == updateActionDebugS2CPayload.eid()).findFirst().ifPresent(robot -> robot.actionI = updateActionDebugS2CPayload.actionI());
			*///?} else {
			((DebugRenderers)client.field_1769.field_63067).robotmod$getActionDebugRenderer().entities.stream().filter(e -> e.method_5628() == updateActionDebugS2CPayload.eid()).findFirst().ifPresent(robot -> robot.actionI = updateActionDebugS2CPayload.actionI());
			//?}
		}))));

		ClientPlayNetworking.registerGlobalReceiver(UpdateHeldItemS2CPayload.ID, ((updateHeldItemS2CPayload, context) -> {
			class_310 client = context.client();
			class_1297 entity = client.field_1687.method_8469(updateHeldItemS2CPayload.eid());

			class_897<?, ?> renderer = client.method_1561().method_3953(entity);
			if (renderer instanceof RobotEntityRenderer robotEntityRenderer && entity instanceof RobotEntity robotEntity) {
				robotEntity.inv.method_5447(robotEntity.slot, updateHeldItemS2CPayload.heldItem());
				RobotEntityRenderState state = robotEntityRenderer.method_62425(robotEntity, 0);
				robotEntityRenderer.updateRenderState(robotEntity, state, 0);
			}
		}));

		ClientPlayNetworking.registerGlobalReceiver(RobotEntityUpdateHeadRotationS2CPayload.ID, ((entityUpdateHeadRotationS2CPayload, context) -> {
			class_310 client = context.client();
			class_1297 entity = client.field_1687.method_8469(entityUpdateHeadRotationS2CPayload.eid());

			if (entity == null) return;

			RobotEntity robot = (RobotEntity)entity;

			robot.setHeadPitch(entityUpdateHeadRotationS2CPayload.pitch());
			robot.method_5847(entityUpdateHeadRotationS2CPayload.yaw());
		}));
	}
}
