package me.illia.robotmod.screen;

import me.illia.robotmod.Robotmod;
import me.illia.robotmod.Util;
import me.illia.robotmod.actions.*;
import me.illia.robotmod.registry.ModRegistries;
import net.minecraft.class_11905;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_5676;
import net.minecraft.class_6381;
import net.minecraft.class_6382;
import net.minecraft.class_8012;
import org.lwjgl.glfw.GLFW;

import java.util.ArrayList;
import java.util.List;

public class ActionsWidget extends class_339 {
	private final ArrayList<Action> actions;
	private final List<ParamWidgetDescriptor> paramWidgets = new ArrayList<>();

	public static final int ACTION_PADDING = 3;

	public ActionsWidget(int x, int y, int w, int h, ArrayList<Action> actions) {
		super(x, y, w, h, Util.t("menu.robotmod.actions"));
		this.actions = actions;
		initParamWidgets();
	}

	public ArrayList<Action> save() {
		for (ParamWidgetDescriptor desc : paramWidgets) {
			Action action = actions.get(desc.actionI());
			ActionParamDescriptor paramDesc = desc.desc();
			class_339 widget = desc.widget();

			String paramName = Util.key(paramDesc.name());
			Action.ParamValue paramValue = switch (paramDesc.type()) {
				case Int -> {
					if (widget instanceof class_342 tf) {
						try {
							yield new Action.ParamValue.IntParam(Integer.parseInt(tf.method_1882()));
						} catch (NumberFormatException e) {
							yield new Action.ParamValue.IntParam(0);
						}
					} else {
						yield null;
					}
				}
				case Float -> {
					if (widget instanceof class_342 tf) {
						try {
							yield new Action.ParamValue.FloatParam(Float.parseFloat(tf.method_1882()));
						} catch (NumberFormatException e) {
							yield new Action.ParamValue.FloatParam(0);
						}
					} else {
						yield null;
					}
				}
				case String -> {
					if (widget instanceof class_342 tf) {
						yield new Action.ParamValue.StringParam(tf.method_1882());
					} else {
						yield null;
					}
				}
				case Bool -> {
					if (widget instanceof class_5676<?> cb && cb.method_32603() instanceof Boolean val) {
						yield new Action.ParamValue.BoolParam(val);
					} else {
						yield null;
					}
				}
				case Dir -> {
					if (widget instanceof class_5676<?> cb && cb.method_32603() instanceof Direction val) {
						yield new Action.ParamValue.DirParam(val);
					} else {
						yield null;
					}
				}
			};

			if (paramValue != null) {
				action.getParams().put(paramName, paramValue);
			}
		}

		return actions;
	}

	//? if <1.21.10 {
	/*@Override
	public boolean charTyped(char chr, int modifiers) {
		for (ParamWidgetDescriptor w : paramWidgets) {
			if (w.widget() instanceof TextFieldWidget tf && tf.isFocused()) tf.setText(tf.getText() + chr);
		}
		return super.charTyped(chr, modifiers);
	}

	@Override
	public boolean mouseClicked(double mouseX, double mouseY, int button) {
		boolean handled = false;
		for (ParamWidgetDescriptor widget : paramWidgets) {
			if (widget.widget() instanceof TextFieldWidget tf) {
				if (tf.isMouseOver(mouseX, mouseY) && button == GLFW.GLFW_MOUSE_BUTTON_LEFT) {
					for (ParamWidgetDescriptor w : paramWidgets) {
						w.widget().setFocused(false);
					}
					tf.setFocused(true);
				}
			}
			handled |= widget.widget().mouseClicked(mouseX, mouseY, button);
		}

		if (!handled) {
			for (ParamWidgetDescriptor w : paramWidgets) {
				w.widget().setFocused(false);
			}
		}

		return handled || super.mouseClicked(mouseX, mouseY, button);
	}

	@Override
	public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
		boolean handled = false;
		for (ParamWidgetDescriptor w : paramWidgets) {
			if (w.widget() instanceof TextFieldWidget tf) handled |= tf.keyPressed(keyCode, scanCode, modifiers);
		};
		return handled || super.keyPressed(keyCode, scanCode, modifiers);
	}
	*///?} else {
	@Override
	public boolean method_25400(class_11905 input) {
		for (ParamWidgetDescriptor w : paramWidgets) {
			if (w.widget() instanceof class_342 tf && tf.method_25370()) tf.method_1852(tf.method_1882() + input.method_74226());
		}
		return super.method_25400(input);
	}

	@Override
	public boolean method_25402(class_11909 click, boolean doubled) {
		boolean handled = false;
		double mouseX = click.comp_4798();
		double mouseY = click.comp_4799();
		int button = click.method_74245();
		for (ParamWidgetDescriptor widget : paramWidgets) {
			if (widget.widget() instanceof class_342 tf) {
				if (tf.method_25405(mouseX, mouseY) && button == GLFW.GLFW_MOUSE_BUTTON_LEFT) {
					for (ParamWidgetDescriptor w : paramWidgets) {
						w.widget().method_25365(false);
					}
					tf.method_25365(true);
				}
			}
			handled |= widget.widget().method_25402(click, doubled);
		}
		if (!handled) {
			for (ParamWidgetDescriptor w : paramWidgets) {
				w.widget().method_25365(false);
			}
		}

		return handled || super.method_25402(click, doubled);
	}

	@Override
	public boolean method_25404(class_11908 input) {
		boolean handled = false;
		for (ParamWidgetDescriptor w : paramWidgets) {
			if (w.widget() instanceof class_342 tf) handled |= tf.method_25404(input);
		};
		return handled || super.method_25404(input);
	}

	//?}

	private void initParamWidgets() {
		class_327 renderer = class_310.method_1551().field_1772;
		int actionI = 0;

		for (Action action : actions) {
			String actionTxt = Util.str(action).getString();
			int actionTxtW = renderer.method_1727(actionTxt);
			int y = method_46427() + (renderer.field_2000 + 10) * actionI + ACTION_PADDING;

			int i = 0;
			CustomAction customAction = ModRegistries.ACTION_TYPE.method_63535(action.actionType);
			for (ActionParamDescriptor desc : customAction.paramDescriptors()) {
				i++;
				int widgetX = method_46426() + actionTxtW + 60 * (i - 1);
				int paramLabelX = method_46426() + actionTxtW + 60 * i;

				switch (desc.type()) {
					case Int -> {
						class_342 widget = new class_342(renderer, widgetX, y, 60, 20, desc.name());
						widget.method_1890(s -> {
							try {
								Integer.parseInt(s);
								return true;
							} catch (NumberFormatException _e) {
								return s.isEmpty();
							}
						});
						class_2588 content = (class_2588)desc.name().method_10851();
						Action.ParamValue val = action.getParams().get(content.method_11022());
						if (val instanceof Action.ParamValue.IntParam(int value)) {
							widget.method_1852(Integer.toString(value));
						}

						paramWidgets.add(new ParamWidgetDescriptor(widget, desc, actionI, paramLabelX));
					}
					case Float -> {
						class_342 widget = new class_342(renderer, widgetX, y, 60, 20, desc.name());
						widget.method_1890(s -> {
							if (s.isEmpty() || s.equals("-") || s.equals(".") || s.equals("-.")) return true;
							try {
								Float.parseFloat(s);
								return true;
							} catch (NumberFormatException _e) {
								return false;
							}
						});

						class_2588 content = (class_2588)desc.name().method_10851();
						Action.ParamValue val = action.getParams().get(content.method_11022());
						if (val instanceof Action.ParamValue.FloatParam(float value)) {
							widget.method_1852(Float.toString(value));
						}

						paramWidgets.add(new ParamWidgetDescriptor(widget, desc, actionI, paramLabelX));
					}
					case String -> {
						class_342 widget = new class_342(renderer, widgetX, y, 60, 20, desc.name());

						class_2588 content = (class_2588)desc.name().method_10851();
						Action.ParamValue val = action.getParams().get(content.method_11022());
						if (val instanceof Action.ParamValue.StringParam(String value)) {
							widget.method_1852(value);
						}

						paramWidgets.add(new ParamWidgetDescriptor(widget, desc, actionI, paramLabelX));
					}
					case Bool -> {
						class_5676<Boolean> boolWidget = class_5676.method_32614()
							.method_32616()
							.method_35723(widgetX, y, 60, 20, desc.name());

						class_2588 content = (class_2588)desc.name().method_10851();
						Action.ParamValue val = action.getParams().get(content.method_11022());
						if (val instanceof Action.ParamValue.BoolParam(boolean value)) {
							boolWidget.method_32605(value);
						}

						paramWidgets.add(new ParamWidgetDescriptor(boolWidget, desc, actionI, paramLabelX));
					}
					case Dir -> {
						class_5676<Direction> dirWidget = class_5676.<Direction>method_32606((d) -> Util.t(d.method_15434()))
							.method_32624(Direction.values())
							.method_32619(Direction.North)
							.method_32616()
							.method_35723(widgetX, y, 60, 20, desc.name());

						class_2588 content = (class_2588)desc.name().method_10851();
						Action.ParamValue val = action.getParams().get(content.method_11022());
						if (val instanceof Action.ParamValue.DirParam(Direction value)) {
							dirWidget.method_32605(value);
						}


						paramWidgets.add(new ParamWidgetDescriptor(dirWidget, desc, actionI, paramLabelX));
					}
				}

			}

			actionI++;
		}
	}

	@Override
	public void method_48579(class_332 context, int mouseX, int mouseY, float deltaTicks) {
		Util.border(context, method_46426(), method_46427(), method_25368(), method_25364(), class_8012.field_44941);

		class_327 renderer = class_310.method_1551().field_1772;
		int i = 0;

		for (Action action : actions) {
			String actionTxt = Util.str(action).getString();
			int y = method_46427() + (renderer.field_2000 + 10) * i + ACTION_PADDING;

			int textX = method_46426() + ACTION_PADDING;

			context.method_51433(renderer, actionTxt, textX, y, class_8012.field_54557, true);
			i++;
		}

		// Render all param widgets
		for (ParamWidgetDescriptor widget : paramWidgets) {
			method_25358(Math.max(method_25368(), renderer.method_1727(widget.desc().name().getString())));
			int actionH = (renderer.field_2000 + 10) * widget.actionI() + ACTION_PADDING;
			method_53533(Math.max(method_25364(), actionH + widget.widget().method_25364()));

			String paramName = widget.desc().name().getString();
			context.method_51433(
				renderer,
				paramName,
				widget.paramLabelX() + ACTION_PADDING,
				method_46427() + actionH,
				0xFF0000FF,
				true
			);

			method_25358(Math.max(method_25368(), widget.widget().method_25368() + renderer.method_1727(widget.desc().name().getString())));

			widget.widget().method_25394(context, mouseX, mouseY, deltaTicks);
		}
	}

	@Override
	protected void method_47399(class_6382 builder) {
		for (Action action : this.actions) {
			builder.method_37033(class_6381.field_33788, Util.str(action).getString());
			CustomAction customAction = ModRegistries.ACTION_TYPE.method_63535(action.actionType);

			if (customAction == null) {
				Robotmod.LOGGER.warn("There's no registered action for the given actionType: {}", action.actionType);
				return;
			}

			for (ActionParamDescriptor desc : customAction.paramDescriptors()) {
				builder.method_37033(class_6381.field_33790, desc.name().getString());
				Action.ParamValue value = action.getParams().get(((class_2588)desc.name().method_10851()).method_11022());
				builder.method_37033(class_6381.field_33790, Action.ParamValue.val(value));
			}
		}
	}
}
