package me.illia.robotmod.screen;

import me.illia.robotmod.Util;
import me.illia.robotmod.attachment.TeleportPoint;
import me.illia.robotmod.attachment.TeleportPointAttachedData;
import me.illia.robotmod.networking.RequestTeleportC2SPayload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_11908;
import net.minecraft.class_1661;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_4185;
import net.minecraft.class_5819;
import net.minecraft.class_7845;
import net.minecraft.client.gui.widget.*;

public class ChooseTeleportScreen extends PlainHandledScreen<ChooseTeleportScreenHandler> {
	private class_7845 grid = new class_7845().method_48635(5).method_48636(5);
	private class_5819 random;

	public ChooseTeleportScreen(ChooseTeleportScreenHandler handler, class_1661 playerInv, class_2561 title) {
		super(handler, playerInv, title);
	}

	@Override
	public void method_25410(class_310 client, int width, int height) {
		grid.method_48206(this::method_37066);

		grid = new class_7845().method_48635(10).method_48636(20);

		initGrid();

		super.method_25410(client, width, height);
	}

	public void handleTeleport(TeleportPoint point) {
		class_2338 pos = point.pos();

		field_22787.field_1724.method_5783(class_3417.field_46945, 1.0f, 3.0f);

		field_22787.field_1724.method_5998(field_22787.field_1724.method_6058()).method_61653(1, field_22787.field_1724);

		class_1937 world = Util.entityWorld(field_22787.field_1724);

		ClientPlayNetworking.send(new RequestTeleportC2SPayload(pos, world.method_27983()));

		field_22787.field_1724.method_3137();

		field_22787.field_1724.method_7353(Util.t("menu.robotmod.teleported", point.name()), true);
	}

	public void initGrid() {
		TeleportPointAttachedData points = field_2797.data;

		grid.method_46458()
			.method_46467()
			.method_46474()
			.method_46464(2);

		int scaledWidth = class_310.method_1551().method_22683().method_4486();

		class_7845.class_7939 adder = grid.method_47610(scaledWidth / (100 + 5));

		for (TeleportPoint point : points.points()) {
			adder.method_47612(class_4185.method_46430(class_2561.method_43470(point.name()), button -> {
				handleTeleport(point);
			}).method_46437(80, 20).method_46431());
		}

		adder.method_47612(class_4185.method_46430(Util.t("menu.robotmod.random"), button -> {
			handleTeleport(points.points().get(random.method_39332(0, points.points().size())));
		}).method_46437(80, 20).method_46431());

		grid.method_48206(this::method_37063);

		this.method_48640();
	}

	@Override
	protected void method_25426() {
		this.random = class_5819.method_43049(System.nanoTime());

		initGrid();
		super.method_25426();
	}

	@Override
	protected void method_48640() {
		grid.method_48222();
	}

	@Override
	protected void method_2389(class_332 context, float deltaTicks, int mouseX, int mouseY) {
	}

	@Override
	public boolean renderTitle() {
		return false;
	}

	//? if <1.21.10 {
	/*@Override
	public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
		if (client.options.inventoryKey.matchesKey(keyCode, scanCode)) {
			close();
			return true;
		}
		return super.keyPressed(keyCode, scanCode, modifiers);
	}
	*///?} else {

	@Override
	public boolean method_25404(class_11908 input) {
		if (field_22787.field_1690.field_1822.method_1417(input)) {
			method_25419();
			return true;
		}
		return super.method_25404(input);
	}
	//?}
}
