package me.illia.robotmod.screen;

import me.illia.robotmod.Util;
import me.illia.robotmod.entity.RobotEntity;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import java.util.List;

public class RobotInventoryScreenHandler extends class_1703 {
	public final class_1661 playerInv;
	public class_1277 inv;
	public List<class_1799> stacks;
	public int eid;

	public RobotInventoryScreenHandler(int syncId, class_1661 playerInv, RobotScreenHandlerData robotScreenHandlerData) {
		super(ModScreenHandlers.ROBOT_INVENTORY_SCREEN_HANDLER, syncId);
		this.playerInv = playerInv;
		this.stacks = robotScreenHandlerData.stacks();
		this.eid = robotScreenHandlerData.eid();
		this.inv = new class_1277(stacks.toArray(new class_1799[]{})) {
			@Override
			public void method_5431() {
				class_1937 world = Util.entityWorld(playerInv.field_7546);
				if (!world.method_8608()) {
					RobotEntity entity = (RobotEntity)world.method_8469(eid);
					for (int i = 0; i < field_5828.size(); i++) {
						class_1799 stack = field_5828.get(i);
						entity.inv.field_5828.set(i, stack);
					}
				}
				super.method_5431();
			}
		};

		int half = 9;
		for (int i = 0; i < stacks.size(); i++) {
			int x = 8 + 18 * (i % half);
			int y = (i < half) ? 18 : 36; // top row 110, bottom row 230
			int finalI = i;
			method_7621(new class_1735(inv, finalI, x, y) {
				@Override
				public void method_7668() {
					RobotEntity robot = (RobotEntity)Util.entityWorld(playerInv.field_7546).method_8469(eid);
					robot.inv.method_5447(finalI, this.method_7677());
					super.method_7668();
				}
			});
		}

		addPlayerInv(playerInv);
		addPlayerHotbar(playerInv);
	}

	public void addPlayerInv(class_1661 inv) {
		for (int i = 0; i < 3; i++) {
			for (int j = 0; j < 9; j++) {
				this.method_7621(new class_1735(inv, j + (i + 1) * 9, 8 + j * 18, 56 + i * 18));
			}
		}
	}

	public void addPlayerHotbar(class_1661 inv) {
		for (int i = 0; i < 9; i++) {
			this.method_7621(new class_1735(inv, i, 8 + i * 18, 114));
		}
	}

	@Override
	public class_1799 method_7601(class_1657 player, int slot) {
		return class_1799.field_8037;
	}

	@Override
	public boolean method_7597(class_1657 player) {
		return true;
	}
}
