package me.illia.robotmod.screen;

import me.illia.robotmod.Util;
import me.illia.robotmod.actions.Action;
import me.illia.robotmod.registry.ModRegistries;
import net.minecraft.class_10799;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_5676;
import me.illia.robotmod.entity.RobotEntity;
import java.util.ArrayList;
import java.util.HashMap;

public class RobotScreen extends PlainHandledScreen<RobotScreenHandler> {
	private class_5676<class_2960> actionTypeBtn;
	private ActionsWidget actionsWidget;

	public RobotScreen(RobotScreenHandler handler, class_1661 inventory, class_2561 title) {
		super(handler, inventory, title);
		this.field_2792 = 226;
	}

	public RobotEntity getRobot() {
		class_1297 entity = class_310.method_1551().field_1687.method_8469(field_2797.getEid());
		RobotEntity robotEntity = (RobotEntity)entity;

		if (robotEntity == null) {
			throw new RuntimeException("robot entity is null");
		}

		return robotEntity;
	}

	public void recreateActionsWidget(int x, int y, int width, int height, ArrayList<Action> actions, boolean remove) {
		RobotEntity robot = getRobot();

		if (remove) {
			this.method_37066(actionsWidget);
		}

		actionsWidget = new ActionsWidget(x, y, width, height, actions);
		this.method_37063(actionsWidget);

		robot.actions = actions;
	}

	@Override
	protected void method_25426() {
		int x = (field_22789 - field_2792) / 2 + field_25267;
		int y = (field_22790 - field_2779) / 2 + field_25268;

		actionTypeBtn = class_5676.<class_2960>method_32606(Util::str)
			.method_32620(ModRegistries.ACTION_TYPE.method_10235())
			.method_35723(x + 25, y + 10, 120, 20, Util.t("menu.robotmod.action_type"));

		this.method_37063(actionTypeBtn);

		this.method_37063(class_4185.method_46430(Util.t("menu.robotmod.remove_last"), (btn) -> {
			ArrayList<Action> actions = actionsWidget.save();

			if (!actions.isEmpty())
				actions.removeLast();

			int prevWidth = actionsWidget.method_25368();
			int prevHeight = actionsWidget.method_25364();
			recreateActionsWidget(x, y + 60, prevWidth, prevHeight, actions, true);
		}).method_46434(x, y + 25, 100, 20).method_46431());

		recreateActionsWidget(x, y + 60, 180, 80, getRobot().actions, false);
		this.method_37063(actionsWidget);

		this.method_37063(class_4185.method_46430(Util.t("menu.robotmod.add"), button -> {
			ArrayList<Action> actions = actionsWidget.save();

			HashMap<String, Action.ParamValue> args = new HashMap<>();
			actions.add(new Action(actionTypeBtn.method_32603(), args));

			int prevWidth = actionsWidget.method_25368();
			int prevHeight = actionsWidget.method_25364();
			recreateActionsWidget(x, y + 35, prevWidth, prevHeight, actions, true);
		}).method_46434(x, y + 10, 20, 20).method_46431());

		super.method_25426();
	}

	@Override
	public void method_25419() {
		getRobot().save(actionsWidget.save());
		super.method_25419();
	}

	@Override
	protected void method_2389(class_332 context, float deltaTicks, int mouseX, int mouseY) {
		int x = (field_22789 - field_2792) / 2;
		int y = (field_22790 - field_2779) / 2;

		//? if >= 1.21.6 {
		context.method_25290(class_10799.field_56883, Util.id("textures/gui/robot.png"), x, y, 0, 0, field_2792, field_2779, field_2792, field_2779);
		//?} else {
		/*context.drawTexture(RenderLayer::getGuiTextured, Util.id("textures/gui/robot.png"), x, y, 0, 0, backgroundWidth, backgroundHeight, backgroundWidth, backgroundHeight);
		*///?}
	}

	@Override
	public void method_25394(class_332 context, int mouseX, int mouseY, float deltaTicks) {
		method_64508(context);
		super.method_25394(context, mouseX, mouseY, deltaTicks);
	}
}
