/*
 * Decompiled with CFR 0.152.
 */
package me.illia.robotmod.networking;

import java.util.ArrayList;
import java.util.Set;
import me.illia.robotmod.actions.Action;
import me.illia.robotmod.attachment.ModAttachmentTypes;
import me.illia.robotmod.attachment.TeleportPointAttachedData;
import me.illia.robotmod.block.ModBlocks;
import me.illia.robotmod.block.TeleporterBlock;
import me.illia.robotmod.entity.RobotEntity;
import me.illia.robotmod.networking.GetTeleportPointsC2SPayload;
import me.illia.robotmod.networking.GetTeleportPointsS2CPayload;
import me.illia.robotmod.networking.RequestTeleportC2SPayload;
import me.illia.robotmod.networking.RobotActionsSyncC2SPayload;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;

public class ModNetworking {
    public static void init() {
        ServerPlayNetworking.registerGlobalReceiver(RequestTeleportC2SPayload.ID, (requestTeleportC2SPayload, context) -> {
            class_2680 state = context.player().method_51469().method_8320(requestTeleportC2SPayload.pos());
            if (state.method_26204() == ModBlocks.TELEPORTER_BLOCK && ((Boolean)state.method_11654((class_2769)TeleporterBlock.CHARGED)).booleanValue() && context.player() instanceof class_3222) {
                context.server().execute(() -> context.player().method_48105(context.server().method_3847(requestTeleportC2SPayload.world()), (double)requestTeleportC2SPayload.pos().method_10263() + 0.5, (double)requestTeleportC2SPayload.pos().method_10264() + 0.4, (double)requestTeleportC2SPayload.pos().method_10260() + 0.5, Set.of(), 0.0f, 0.0f, true));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(RobotActionsSyncC2SPayload.ID, (robotActionsSyncC2SPayload, context) -> {
            MinecraftServer server = context.server();
            class_3218 world = server.method_3847(robotActionsSyncC2SPayload.world());
            if (world == null) {
                return;
            }
            class_1297 entity = world.method_8469(robotActionsSyncC2SPayload.eid());
            if (entity instanceof RobotEntity) {
                RobotEntity robot = (RobotEntity)entity;
                robot.save(new ArrayList<Action>(robotActionsSyncC2SPayload.actions()));
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(GetTeleportPointsC2SPayload.ID, (getTeleportPointsC2SPayload, context) -> {
            MinecraftServer server = context.server();
            class_3218 world = server.method_3847(getTeleportPointsC2SPayload.world());
            TeleportPointAttachedData data = (TeleportPointAttachedData)world.getAttachedOrElse(ModAttachmentTypes.TELEPORT_POINTS, (Object)TeleportPointAttachedData.DEFAULT);
            context.responseSender().sendPacket((class_8710)new GetTeleportPointsS2CPayload(data));
        });
        ClientPlayNetworking.registerGlobalReceiver(GetTeleportPointsS2CPayload.ID, (getTeleportPointsS2CPayload, context) -> {
            TeleportPointAttachedData.DATA = getTeleportPointsS2CPayload.data();
        });
    }
}

