/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.ALDataComponents;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.mixins.MerchantOfferAccess;
import brightspark.asynclocator.platform.Services;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.ItemCost;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import org.jetbrains.annotations.Nullable;

public class MerchantLogic {
    private MerchantLogic() {
    }

    public static void invalidateMap(AbstractVillager merchant, ItemStack mapStack) {
        mapStack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)"item.minecraft.map"));
        mapStack.remove(ALDataComponents.LOCATING);
        merchant.getOffers().stream().filter(offer -> offer.getResult() == mapStack).findFirst().ifPresentOrElse(offer -> MerchantLogic.removeOffer(merchant, offer), () -> ALConstants.logWarn("Failed to find merchant offer for map stack instance used in invalidateMap", new Object[0]));
    }

    public static void removeOffer(AbstractVillager merchant, MerchantOffer offer) {
        if (Services.CONFIG.removeOffer()) {
            if (merchant.getOffers().remove((Object)offer)) {
                ALConstants.logInfo("Removed merchant map offer", new Object[0]);
            } else {
                ALConstants.logWarn("Failed to remove merchant map offer", new Object[0]);
            }
        } else {
            ((MerchantOfferAccess)offer).setMaxUses(0);
            offer.setToOutOfStock();
            ALConstants.logInfo("Marked merchant map offer as out of stock", new Object[0]);
        }
    }

    public static void handleLocationFound(ServerLevel level, AbstractVillager merchant, ItemStack mapStack, @Nullable String displayNameKey, Holder<MapDecorationType> destinationTypeHolder, @Nullable BlockPos pos) {
        if (pos == null) {
            ALConstants.logInfo("No location found - invalidating merchant offer", new Object[0]);
            MerchantLogic.invalidateMap(merchant, mapStack);
        } else {
            ALConstants.logInfo("Location found at {} - updating treasure map in merchant offer", pos);
            MutableComponent nameComponent = displayNameKey == null || displayNameKey.isEmpty() ? null : Component.translatable((String)displayNameKey);
            CommonLogic.finalizeMap(mapStack, level, pos, 2, destinationTypeHolder, (Component)nameComponent);
        }
        Player player = merchant.getTradingPlayer();
        if (player instanceof ServerPlayer) {
            int n;
            ServerPlayer tradingPlayer = (ServerPlayer)player;
            ALConstants.logInfo("Player {} currently trading - updating merchant offers", tradingPlayer);
            if (merchant instanceof Villager) {
                Villager villager = (Villager)merchant;
                n = villager.getVillagerData().level();
            } else {
                n = 1;
            }
            int villagerLevel = n;
            tradingPlayer.sendMerchantOffers(tradingPlayer.containerMenu.containerId, merchant.getOffers(), villagerLevel, merchant.getVillagerXp(), merchant.showProgressBar(), merchant.canRestock());
        }
    }

    public static MerchantOffer updateMapAsync(Entity pTrader, int emeraldCost, String displayNameKey, Holder<MapDecorationType> destinationTypeHolder, int maxUses, int villagerXp, TagKey<Structure> destination) {
        return MerchantLogic.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, destination, merchant.blockPosition(), 100, true).thenOnServerThread(pos -> MerchantLogic.handleLocationFound(level, merchant, mapStack, displayNameKey, destinationTypeHolder, pos)));
    }

    public static MerchantOffer updateMapAsync(Entity pTrader, int emeraldCost, String displayNameKey, Holder<MapDecorationType> destinationTypeHolder, int maxUses, int villagerXp, HolderSet<Structure> structureSet) {
        return MerchantLogic.updateMapAsyncInternal(pTrader, emeraldCost, maxUses, villagerXp, (level, merchant, mapStack) -> AsyncLocator.locate(level, structureSet, merchant.blockPosition(), 100, true).thenOnServerThread(pair -> {
            BlockPos pos = pair != null ? (BlockPos)pair.getFirst() : null;
            MerchantLogic.handleLocationFound(level, merchant, mapStack, displayNameKey, destinationTypeHolder, pos);
        }));
    }

    private static MerchantOffer updateMapAsyncInternal(Entity trader, int emeraldCost, int maxUses, int villagerXp, MapUpdateTask task) {
        if (trader instanceof AbstractVillager) {
            AbstractVillager merchant = (AbstractVillager)trader;
            Level level = trader.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ItemStack mapStack = CommonLogic.createMerchantMap(serverLevel);
                ALConstants.logDebug("Created merchant map with MapId {} for offer", mapStack.get(DataComponents.MAP_ID));
                task.apply(serverLevel, merchant, mapStack);
                ItemCost emeraldItemCost = new ItemCost((ItemLike)Items.EMERALD, emeraldCost);
                Optional<ItemCost> compassCost = Optional.of(new ItemCost((ItemLike)Items.COMPASS));
                return new MerchantOffer(emeraldItemCost, compassCost, mapStack, maxUses, villagerXp, 0.2f);
            }
        }
        ALConstants.logInfo("Merchant is not of type {} or level is not ServerLevel - not running async logic", AbstractVillager.class.getSimpleName());
        return null;
    }

    public static interface MapUpdateTask {
        public void apply(ServerLevel var1, AbstractVillager var2, ItemStack var3);
    }
}

