/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.mixins.DolphinAccessor;
import brightspark.asynclocator.mixins.DolphinSwimToTreasureGoalStuckAccessor;
import brightspark.asynclocator.platform.Services;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.level.levelgen.structure.Structure;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.world.entity.animal.Dolphin$DolphinSwimToTreasureGoal"}, priority=800)
public class DolphinSwimToTreasureGoalMixin {
    private AsyncLocator.LocateTask<?> locateTask = null;
    @Shadow
    @Final
    private Dolphin dolphin;

    @Redirect(method={"start"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;findNearestMapStructure(Lnet/minecraft/tags/TagKey;Lnet/minecraft/core/BlockPos;IZ)Lnet/minecraft/core/BlockPos;"))
    public BlockPos redirectFindNearestMapStructure(ServerLevel level, TagKey<Structure> structureTag, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        if (!Services.CONFIG.dolphinTreasureEnabled()) {
            return level.findNearestMapStructure(structureTag, pos, searchRadius, skipKnownStructures);
        }
        ALConstants.logDebug("Intercepted DolphinSwimToTreasureGoal findNearestMapStructure call", new Object[0]);
        this.handleFindTreasureAsync(level, pos);
        return null;
    }

    @Inject(method={"start"}, at={@At(value="RETURN")})
    private void asynclocator$undoVanillaStuckWhenAsync(CallbackInfo ci) {
        if (this.locateTask != null) {
            ((DolphinSwimToTreasureGoalStuckAccessor)((Object)this)).asynclocator$setStuck(false);
        }
    }

    @Inject(method={"canContinueToUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void continueToUseIfLocatingTreasure(CallbackInfoReturnable<Boolean> cir) {
        if (this.locateTask != null && this.dolphin.gotFish() && this.dolphin.getAirSupply() >= 100) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    public void stopLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            ALConstants.logDebug("Locating task ongoing - cancelling during stop()", new Object[0]);
            this.locateTask.cancel();
            this.locateTask = null;
        }
        ((DolphinAccessor)this.dolphin).asynclocator$setTreasurePos(null);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void skipTickingIfLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            ci.cancel();
        }
    }

    private void handleFindTreasureAsync(ServerLevel level, BlockPos origin) {
        try {
            Registry registry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            Optional holderSetOpt = registry.get(StructureTags.DOLPHIN_LOCATED);
            if (holderSetOpt.isPresent()) {
                HolderSet set = (HolderSet)holderSetOpt.get();
                this.locateTask = AsyncLocator.locate(level, (HolderSet<Structure>)set, origin, 50, false).thenOnServerThread(pair -> this.handleLocationFound(level, pair == null ? null : (BlockPos)pair.getFirst()));
                return;
            }
            ALConstants.logWarn("DOLPHIN_LOCATED tag not found; falling back to ServerLevel.findNearestMapStructure path", new Object[0]);
        }
        catch (Throwable t) {
            ALConstants.logError(t, "Failed to resolve HolderSet for DOLPHIN_LOCATED", new Object[0]);
        }
        this.locateTask = AsyncLocator.locate(level, (TagKey<Structure>)StructureTags.DOLPHIN_LOCATED, origin, 50, false).thenOnServerThread(pos -> this.handleLocationFound(level, (BlockPos)pos));
    }

    private void handleLocationFound(ServerLevel level, BlockPos pos) {
        this.locateTask = null;
        if (pos != null) {
            ((DolphinAccessor)this.dolphin).asynclocator$setTreasurePos(pos);
            ((DolphinSwimToTreasureGoalStuckAccessor)((Object)this)).asynclocator$setStuck(false);
            level.broadcastEntityEvent((Entity)this.dolphin, (byte)38);
            ALConstants.logInfo("Location found at {} - dolphin will now swim to treasure", pos);
        } else {
            ALConstants.logInfo("No location found - dolphin will continue normal behavior", new Object[0]);
        }
    }
}

