/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.logic.EnderEyeItemLogic;
import brightspark.asynclocator.platform.Services;
import com.mojang.datafixers.util.Pair;
import net.minecraft.advancements.critereon.UsedEnderEyeTrigger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.phys.BlockHitResult;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={EnderEyeItem.class})
public class EnderEyeItemMixin {
    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;findNearestMapStructure(Lnet/minecraft/tags/TagKey;Lnet/minecraft/core/BlockPos;IZ)Lnet/minecraft/core/BlockPos;"))
    public BlockPos levelFindNearestMapFeature(ServerLevel serverlevel, TagKey<Structure> pStructureTag, BlockPos pPos, int pRadius, boolean pSkipExistingChunks) {
        if (Services.CONFIG.eyeOfEnderEnabled()) {
            ALConstants.logDebug("Intercepted EnderEyeItem#use call", new Object[0]);
            return BlockPos.ZERO;
        }
        return serverlevel.findNearestMapStructure(pStructureTag, pPos, pRadius, pSkipExistingChunks);
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/chunk/ChunkGenerator;findNearestMapStructure(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/core/HolderSet;Lnet/minecraft/core/BlockPos;IZ)Lcom/mojang/datafixers/util/Pair;"))
    public Pair<BlockPos, Holder<Structure>> generatorFindNearestMapFeature(ChunkGenerator generator, ServerLevel level, HolderSet<Structure> set, BlockPos origin, int radius, boolean skipExisting) {
        if (Services.CONFIG.eyeOfEnderEnabled()) {
            ALConstants.logDebug("Intercepted EnderEyeItem#use ChunkGenerator.findNearestMapStructure", new Object[0]);
            return null;
        }
        return generator.findNearestMapStructure(level, set, origin, radius, skipExisting);
    }

    @Inject(method={"use"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/EyeOfEnder;setItem(Lnet/minecraft/world/item/ItemStack;)V")}, locals=LocalCapture.CAPTURE_FAILSOFT)
    public void startAsyncLocateTask(Level pLevel, Player pPlayer, InteractionHand pHand, CallbackInfoReturnable<InteractionResult> cir, ItemStack itemstack, BlockHitResult blockhitresult, ServerLevel serverlevel, BlockPos blockpos, EyeOfEnder eyeofender) {
        if (!Services.CONFIG.eyeOfEnderEnabled()) {
            return;
        }
        EnderEyeItemLogic.locateAsync(serverlevel, pPlayer, eyeofender, (EnderEyeItem)this);
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/EyeOfEnder;signalTo(Lnet/minecraft/core/BlockPos;)V"))
    public void eyeOfEnderSignalTo(EyeOfEnder eyeOfEnder, BlockPos blockpos) {
        if (!Services.CONFIG.eyeOfEnderEnabled()) {
            eyeOfEnder.signalTo(blockpos);
        }
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/advancements/critereon/UsedEnderEyeTrigger;trigger(Lnet/minecraft/server/level/ServerPlayer;Lnet/minecraft/core/BlockPos;)V"))
    private void triggerUsedEnderEyeCriteria(UsedEnderEyeTrigger trigger, ServerPlayer player, BlockPos pos) {
        if (!Services.CONFIG.eyeOfEnderEnabled()) {
            trigger.trigger(player, pos);
        }
    }

    @Redirect(method={"use"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/player/Player;awardStat(Lnet/minecraft/stats/Stat;)V"))
    public void playerAwardStat(Player player, Stat<?> pStat) {
        if (!Services.CONFIG.eyeOfEnderEnabled()) {
            player.awardStat(pStat);
        }
    }
}

