/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.logic.ExplorationMapFunctionLogic;
import brightspark.asynclocator.platform.Services;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.ExplorationMapFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ExplorationMapFunction.class})
public abstract class ExplorationMapFunctionMixin {
    @Shadow
    @Final
    TagKey<Structure> destination;
    @Shadow
    @Final
    byte zoom;
    @Shadow
    @Final
    int searchRadius;
    @Shadow
    @Final
    boolean skipKnownStructures;
    @Unique
    private ResourceKey<MapDecorationType> asyncLocator$decorationTypeKey;

    @Inject(method={"<init>(Ljava/util/List;Lnet/minecraft/tags/TagKey;Lnet/minecraft/core/Holder;BIZ)V"}, at={@At(value="RETURN")})
    private void captureDecorationKey(List<LootItemCondition> conditions, TagKey<Structure> dest, Holder<MapDecorationType> typeHolder, byte zm, int radius, boolean skip, CallbackInfo ci) {
        typeHolder.unwrapKey().ifPresentOrElse(key -> {
            this.asyncLocator$decorationTypeKey = key;
        }, () -> {
            ALConstants.logWarn("Failed to find registered key for MapDecorationType Holder {} in ExplorationMapFunction constructor", typeHolder);
            this.asyncLocator$decorationTypeKey = null;
        });
    }

    @Unique
    private Optional<Holder<MapDecorationType>> getDecorationHolderFromKey(LootContext context) {
        if (this.asyncLocator$decorationTypeKey == null) {
            return Optional.empty();
        }
        return context.getLevel().registryAccess().lookup(Registries.MAP_DECORATION_TYPE).flatMap(registry -> registry.get(this.asyncLocator$decorationTypeKey));
    }

    @Unique
    private static void asyncLocator$refreshMerchantUIIfApplicable(LootContext context) {
        AbstractVillager merchant;
        Player player;
        Entity entity;
        Entity entity2 = entity = context.hasParameter(LootContextParams.THIS_ENTITY) ? (Entity)context.getParameter(LootContextParams.THIS_ENTITY) : null;
        if (entity instanceof AbstractVillager && (player = (merchant = (AbstractVillager)entity).getTradingPlayer()) instanceof ServerPlayer) {
            int n;
            ServerPlayer tradingPlayer = (ServerPlayer)player;
            if (merchant instanceof Villager) {
                Villager villager = (Villager)merchant;
                n = villager.getVillagerData().level();
            } else {
                n = 1;
            }
            int villagerLevel = n;
            tradingPlayer.sendMerchantOffers(tradingPlayer.containerMenu.containerId, merchant.getOffers(), villagerLevel, merchant.getVillagerXp(), merchant.showProgressBar(), merchant.canRestock());
            ALConstants.logDebug("Refreshed merchant offers for trade UI", new Object[0]);
        }
    }

    @Redirect(method={"run(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/storage/loot/LootContext;)Lnet/minecraft/world/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/MapItem;create(Lnet/minecraft/server/level/ServerLevel;IIBZZ)Lnet/minecraft/world/item/ItemStack;"))
    private ItemStack redirectMapItemCreate(ServerLevel serverLevel, int x, int z, byte scale, boolean trackingPosition, boolean unlimitedTracking, ItemStack originalStack_usedByRun, LootContext context_usedByRun) {
        LootContext context = context_usedByRun;
        if (!Services.CONFIG.explorationMapEnabled()) {
            return MapItem.create((ServerLevel)serverLevel, (int)x, (int)z, (byte)scale, (boolean)trackingPosition, (boolean)unlimitedTracking);
        }
        Optional<Holder<MapDecorationType>> mapDecorationHolderOpt = this.getDecorationHolderFromKey(context);
        if (mapDecorationHolderOpt.isEmpty()) {
            ALConstants.logError("ExplorationMap Redirect: Couldn't get MapDecorationType Holder for key {}, falling back to vanilla map creation.", this.asyncLocator$decorationTypeKey);
            return MapItem.create((ServerLevel)serverLevel, (int)x, (int)z, (byte)scale, (boolean)trackingPosition, (boolean)unlimitedTracking);
        }
        ALConstants.logDebug("Redirecting MapItem.create for async locator exploration map {}.", this.destination.location());
        BlockPos originPos = context.hasParameter(LootContextParams.ORIGIN) ? BlockPos.containing((Position)((Position)context.getParameter(LootContextParams.ORIGIN))) : BlockPos.containing((double)x, (double)(serverLevel.getHeight() / 2), (double)z);
        MapItemSavedData mapData = MapItemSavedData.createFresh((double)x, (double)z, (byte)this.zoom, (boolean)false, (boolean)false, (ResourceKey)serverLevel.dimension());
        MapId newMapId = serverLevel.getFreeMapId();
        serverLevel.setMapData(newMapId, mapData);
        ALConstants.logDebug("Saved initial MapItemSavedData for new MapId {} for exploration map.", newMapId);
        ItemStack pendingMapStack = CommonLogic.createManagedMap();
        pendingMapStack.set(DataComponents.MAP_ID, (Object)newMapId);
        ALConstants.logDebug("Assigned MapId {} to exploration map ItemStack.", newMapId);
        AsyncLocator.locate(serverLevel, this.destination, originPos, this.searchRadius, this.skipKnownStructures).thenOnServerThread(foundPos -> {
            Entity thisEntity;
            Component mapName = ExplorationMapFunctionLogic.getCachedName(pendingMapStack);
            BlockPos inventoryPos = context.hasParameter(LootContextParams.ORIGIN) ? BlockPos.containing((Position)((Position)context.getParameter(LootContextParams.ORIGIN))) : null;
            boolean merchantUpdated = false;
            Entity entity = thisEntity = context.hasParameter(LootContextParams.THIS_ENTITY) ? (Entity)context.getParameter(LootContextParams.THIS_ENTITY) : null;
            if (thisEntity instanceof AbstractVillager) {
                AbstractVillager merchant = (AbstractVillager)thisEntity;
                UUID targetId = CommonLogic.getTrackingUUID(pendingMapStack);
                if (targetId != null) {
                    for (MerchantOffer offer : merchant.getOffers()) {
                        ItemStack result = offer.getResult();
                        UUID offerId = CommonLogic.getTrackingUUID(result);
                        if (!targetId.equals(offerId)) continue;
                        if (foundPos != null) {
                            ALConstants.logDebug("Finalizing map in merchant offer (UUID: {})", offerId);
                            CommonLogic.finalizeMap(result, serverLevel, foundPos, this.zoom, (Holder<MapDecorationType>)((Holder)mapDecorationHolderOpt.get()), mapName);
                        } else {
                            ALConstants.logDebug("Clearing pending map in merchant offer (UUID: {})", offerId);
                            CommonLogic.clearPendingState(result);
                        }
                        merchantUpdated = true;
                        break;
                    }
                } else {
                    ALConstants.logWarn("Managed map lacks tracking UUID in trade context: cannot match offer result", new Object[0]);
                }
            }
            if (!merchantUpdated) {
                if (foundPos != null) {
                    ALConstants.logInfo("Async location found for exploration map {}: {}", this.destination.location(), foundPos);
                    if (inventoryPos != null) {
                        Services.EXPLORATION_MAP_FUNCTION_LOGIC.updateMap(pendingMapStack, serverLevel, (BlockPos)foundPos, this.zoom, (Holder<MapDecorationType>)((Holder)mapDecorationHolderOpt.get()), inventoryPos, mapName);
                    } else {
                        CommonLogic.finalizeMap(pendingMapStack, serverLevel, foundPos, this.zoom, (Holder<MapDecorationType>)((Holder)mapDecorationHolderOpt.get()), mapName);
                    }
                } else {
                    ALConstants.logInfo("Async location not found for exploration map {} -> Invalidating map in inventory (if possible)", this.destination.location());
                    if (inventoryPos != null) {
                        Services.EXPLORATION_MAP_FUNCTION_LOGIC.invalidateMap(pendingMapStack, serverLevel, inventoryPos);
                    } else {
                        ALConstants.logWarn("Cannot invalidate exploration map - LootContext lacks ORIGIN parameter.", new Object[0]);
                        CommonLogic.clearPendingState(pendingMapStack);
                    }
                }
            }
            ExplorationMapFunctionMixin.asyncLocator$refreshMerchantUIIfApplicable(context);
        });
        return pendingMapStack;
    }
}

