/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALDataComponents;
import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1806;
import net.minecraft.class_1935;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_3218;
import net.minecraft.class_3902;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9209;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9428;
import org.jetbrains.annotations.Nullable;

public class CommonLogic {
    private static final String MAP_HOVER_NAME_KEY = "menu.working";
    private static final String PENDING_MARKER = "asynclocator.pending";
    private static final String UUID_TRACKER = "asynclocator.pending.uuid";

    private CommonLogic() {
    }

    public static class_1799 createEmptyMap() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8204);
        stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)MAP_HOVER_NAME_KEY));
        class_2487 customData = new class_2487();
        customData.method_10567(PENDING_MARKER, (byte)1);
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customData));
        return stack;
    }

    public static class_1799 createManagedMap() {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8204);
        stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)MAP_HOVER_NAME_KEY));
        class_2487 customData = new class_2487();
        customData.method_10582(UUID_TRACKER, UUID.randomUUID().toString());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)customData));
        stack.method_57379(ALDataComponents.LOCATING, (Object)class_3902.field_17274);
        return stack;
    }

    public static class_1799 createMerchantMap(class_3218 level) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8204);
        class_22 mapData = class_22.method_32363((double)0.0, (double)0.0, (byte)2, (boolean)true, (boolean)true, (class_5321)level.method_27983());
        class_9209 newMapId = level.method_17889();
        stack.method_57379(class_9334.field_49646, (Object)newMapId);
        level.method_17890(newMapId, mapData);
        stack.method_57379(class_9334.field_50239, (Object)class_2561.method_43471((String)MAP_HOVER_NAME_KEY));
        stack.method_57379(ALDataComponents.LOCATING, (Object)class_3902.field_17274);
        return stack;
    }

    public static boolean isEmptyPendingMap(class_1799 stack) {
        if (!stack.method_31574(class_1802.field_8204)) {
            return false;
        }
        if (stack.method_57826(ALDataComponents.LOCATING)) {
            return true;
        }
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (customData == null) {
            return false;
        }
        return customData.method_57450(PENDING_MARKER) || customData.method_57450(UUID_TRACKER);
    }

    @Nullable
    public static UUID getTrackingUUID(class_1799 stack) {
        class_9279 customData = (class_9279)stack.method_58694(class_9334.field_49628);
        if (customData == null) {
            return null;
        }
        class_2487 tag = customData.method_57461();
        String raw = tag.method_10558(UUID_TRACKER).orElse("");
        if (raw.isEmpty()) {
            return null;
        }
        try {
            return UUID.fromString(raw);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }

    public static void clearPendingState(class_1799 mapStack) {
        mapStack.method_57381(ALDataComponents.LOCATING);
        class_9279 currentData = (class_9279)mapStack.method_58694(class_9334.field_49628);
        if (currentData != null) {
            class_2487 newTag = currentData.method_57461();
            newTag.method_10551(PENDING_MARKER);
            newTag.method_10551(UUID_TRACKER);
            if (newTag.method_33133()) {
                mapStack.method_57381(class_9334.field_49628);
            } else {
                mapStack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)newTag));
            }
        }
    }

    public static void finalizeMap(class_1799 mapStack, class_3218 level, class_2338 pos, int scale, class_6880<class_9428> destinationType, @Nullable class_2561 displayName) {
        class_9209 existingId = (class_9209)mapStack.method_58694(class_9334.field_49646);
        class_9209 mapId = existingId != null ? existingId : level.method_17889();
        class_22 mapData = class_22.method_32363((double)pos.method_10263(), (double)pos.method_10260(), (byte)((byte)scale), (boolean)true, (boolean)true, (class_5321)level.method_27983());
        level.method_17890(mapId, mapData);
        if (existingId == null) {
            mapStack.method_57379(class_9334.field_49646, (Object)mapId);
        }
        class_1806.method_8002((class_3218)level, (class_1799)mapStack);
        class_22.method_110((class_1799)mapStack, (class_2338)pos, (String)"+", destinationType);
        if (displayName != null) {
            mapStack.method_57379(class_9334.field_50239, (Object)displayName);
        }
        CommonLogic.clearPendingState(mapStack);
    }

    public static void completeMapUpdate(class_1799 mapStack, class_3218 level, class_2338 pos, class_6880<class_9428> destinationTypeHolder, @Nullable class_2561 displayName) {
        CommonLogic.finalizeMap(mapStack, level, pos, 2, destinationTypeHolder, displayName);
    }

    public static void broadcastChestChanges(class_3218 level, class_2586 be) {
        if (!(be instanceof class_2595)) {
            return;
        }
        class_2595 chestBE = (class_2595)be;
        level.method_18456().forEach(player -> {
            class_1707 chestMenu;
            class_1703 container = player.field_7512;
            if (container instanceof class_1707 && (chestMenu = (class_1707)container).method_7629() == chestBE) {
                chestMenu.method_7623();
            }
        });
    }

    public static void broadcastContainerChanges(class_3218 level, class_2586 be, class_1263 container) {
        level.method_18456().forEach(player -> {
            class_1707 chestMenu;
            class_1703 menu = player.field_7512;
            if (menu instanceof class_1707 && (chestMenu = (class_1707)menu).method_7629() == container) {
                chestMenu.method_7623();
            }
        });
    }
}

