/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.logic.CommonLogic;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_2561;

public class ExplorationMapFunctionLogic {
    private static final Cache<UUID, class_2561> MAP_NAME_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).maximumSize(3000L).build();

    private ExplorationMapFunctionLogic() {
    }

    public static void cacheName(class_1799 stack, class_2561 name) {
        if (name == null) {
            return;
        }
        UUID id = CommonLogic.getTrackingUUID(stack);
        if (id != null) {
            MAP_NAME_CACHE.put((Object)id, (Object)name);
            ALConstants.logDebug("Cached name for map UUID {}", id);
        } else {
            ALConstants.logWarn("Attempted to cache name for map without tracking UUID", new Object[0]);
        }
    }

    public static class_2561 getCachedName(class_1799 stack) {
        UUID id = CommonLogic.getTrackingUUID(stack);
        if (id == null) {
            return null;
        }
        class_2561 name = (class_2561)MAP_NAME_CACHE.getIfPresent((Object)id);
        if (name != null) {
            MAP_NAME_CACHE.invalidate((Object)id);
            ALConstants.logDebug("Retrieved and invalidated cached name for map UUID {}", id);
        }
        return name;
    }
}

