/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.mixins.DolphinAccessor;
import brightspark.asynclocator.mixins.DolphinSwimToTreasureGoalStuckAccessor;
import brightspark.asynclocator.platform.Services;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1433;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_6885;
import net.minecraft.class_7045;
import net.minecraft.class_7924;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.world.entity.animal.Dolphin$DolphinSwimToTreasureGoal"}, priority=800)
public class DolphinSwimToTreasureGoalMixin {
    private AsyncLocator.LocateTask<?> locateTask = null;
    @Shadow
    @Final
    private class_1433 field_6752;

    @Redirect(method={"start"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;findNearestMapStructure(Lnet/minecraft/tags/TagKey;Lnet/minecraft/core/BlockPos;IZ)Lnet/minecraft/core/BlockPos;"))
    public class_2338 redirectFindNearestMapStructure(class_3218 level, class_6862<class_3195> structureTag, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        if (!Services.CONFIG.dolphinTreasureEnabled()) {
            return level.method_8487(structureTag, pos, searchRadius, skipKnownStructures);
        }
        ALConstants.logDebug("Intercepted DolphinSwimToTreasureGoal findNearestMapStructure call", new Object[0]);
        this.handleFindTreasureAsync(level, pos);
        return null;
    }

    @Inject(method={"start"}, at={@At(value="RETURN")})
    private void asynclocator$undoVanillaStuckWhenAsync(CallbackInfo ci) {
        if (this.locateTask != null) {
            ((DolphinSwimToTreasureGoalStuckAccessor)((Object)this)).asynclocator$setStuck(false);
        }
    }

    @Inject(method={"canContinueToUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void continueToUseIfLocatingTreasure(CallbackInfoReturnable<Boolean> cir) {
        if (this.locateTask != null && this.field_6752.method_6487() && this.field_6752.method_5669() >= 100) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    public void stopLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            ALConstants.logDebug("Locating task ongoing - cancelling during stop()", new Object[0]);
            this.locateTask.cancel();
            this.locateTask = null;
        }
        ((DolphinAccessor)this.field_6752).asynclocator$setTreasurePos(null);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void skipTickingIfLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            ci.cancel();
        }
    }

    private void handleFindTreasureAsync(class_3218 level, class_2338 origin) {
        try {
            class_2378 registry = level.method_30349().method_30530(class_7924.field_41246);
            Optional holderSetOpt = registry.method_46733(class_7045.field_37041);
            if (holderSetOpt.isPresent()) {
                class_6885 set = (class_6885)holderSetOpt.get();
                this.locateTask = AsyncLocator.locate(level, (class_6885<class_3195>)set, origin, 50, false).thenOnServerThread(pair -> this.handleLocationFound(level, pair == null ? null : (class_2338)pair.getFirst()));
                return;
            }
            ALConstants.logWarn("DOLPHIN_LOCATED tag not found; falling back to ServerLevel.findNearestMapStructure path", new Object[0]);
        }
        catch (Throwable t) {
            ALConstants.logError(t, "Failed to resolve HolderSet for DOLPHIN_LOCATED", new Object[0]);
        }
        this.locateTask = AsyncLocator.locate(level, (class_6862<class_3195>)class_7045.field_37041, origin, 50, false).thenOnServerThread(pos -> this.handleLocationFound(level, (class_2338)pos));
    }

    private void handleLocationFound(class_3218 level, class_2338 pos) {
        this.locateTask = null;
        if (pos != null) {
            ((DolphinAccessor)this.field_6752).asynclocator$setTreasurePos(pos);
            ((DolphinSwimToTreasureGoalStuckAccessor)((Object)this)).asynclocator$setStuck(false);
            level.method_8421((class_1297)this.field_6752, (byte)38);
            ALConstants.logInfo("Location found at {} - dolphin will now swim to treasure", pos);
        } else {
            ALConstants.logInfo("No location found - dolphin will continue normal behavior", new Object[0]);
        }
    }
}

