/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.SparkConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class AsyncLocatorConfigFabric {
    @SparkConfig.Config(value="asyncLocatorThreads", comment="The maximum number of threads in the async locator thread pool.\nThere's no upper bound to this, however this should only be increased if you're experiencing\nsimultaneous location lookups causing issues AND you have the hardware capable of handling\nthe extra possible threads.\nThe default of 1 should be suitable for most users.\n", min=1.0f, max=2.1474836E9f)
    public static int LOCATOR_THREADS = 1;
    @SparkConfig.Config(value="removeMerchantInvalidMapOffer", comment="When a merchant's treasure map offer ends up not finding a feature location,\nwhether the offer should be removed or marked as out of stock.\n")
    public static boolean REMOVE_OFFER = false;

    private AsyncLocatorConfigFabric() {
    }

    public static void init() {
        Path configFile = FabricLoader.getInstance().getConfigDir().resolve("asynclocator.properties");
        if (Files.exists(configFile, new LinkOption[0])) {
            ALConstants.logInfo("Config file found", new Object[0]);
            try {
                SparkConfig.read(configFile, AsyncLocatorConfigFabric.class);
            }
            catch (IOException | IllegalAccessException e) {
                ALConstants.logError(e, "Failed to read config file {}", configFile);
            }
        } else {
            ALConstants.logInfo("No config file found - creating it", new Object[0]);
            try {
                SparkConfig.write(configFile, AsyncLocatorConfigFabric.class);
            }
            catch (IOException | IllegalAccessException e) {
                ALConstants.logError(e, "Failed to write config file {}", configFile);
            }
        }
    }

    @SparkConfig.Category(value="Feature Toggles")
    public static class FeatureToggles {
        @SparkConfig.Config(value="dolphinTreasureEnabled", comment="If true, enables asynchronous locating of structures for dolphin treasures.")
        public static boolean DOLPHIN_TREASURE_ENABLED = true;
        @SparkConfig.Config(value="eyeOfEnderEnabled", comment="If true, enables asynchronous locating of structures when Eyes Of Ender are thrown.")
        public static boolean EYE_OF_ENDER_ENABLED = true;
        @SparkConfig.Config(value="explorationMspEnabled", comment="If true, enables asynchronous locating of structures for exploration maps found in chests.")
        public static boolean EXPLORATION_MAP_ENABLED = true;
        @SparkConfig.Config(value="locateCommandEnabled", comment="If true, enables asynchronous locating of structures for the locate command.")
        public static boolean LOCATE_COMMAND_ENABLED = true;
        @SparkConfig.Config(value="villagerTradeEnabled", comment="If true, enables asynchronous locating of structures for villager trades.")
        public static boolean VILLAGER_TRADE_ENABLED = true;
    }
}

