/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_9428;

public class AsyncMapTracker {
    private static AsyncMapTracker INSTANCE;
    private final Map<UUID, MapLocationOperation> trackedOperations = new ConcurrentHashMap<UUID, MapLocationOperation>();

    public static AsyncMapTracker getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new AsyncMapTracker();
        }
        return INSTANCE;
    }

    public void addLocationOperation(UUID operationId, MapLocationOperation operation) {
        this.trackedOperations.put(operationId, operation);
    }

    public void completeLocationOperation(UUID operationId, class_2338 foundPosition) {
        MapLocationOperation operation = this.trackedOperations.remove(operationId);
        if (operation != null && operation.completionHandler != null) {
            operation.completionHandler.accept(foundPosition);
        }
    }

    public MapLocationOperation getOperation(UUID operationId) {
        return this.trackedOperations.get(operationId);
    }

    public static class MapLocationOperation {
        private final class_5321<class_1937> dimension;
        private final int scale;
        private final class_6880<class_9428> decorationType;
        private final Consumer<class_2338> completionHandler;

        public MapLocationOperation(class_5321<class_1937> dimension, int scale, class_6880<class_9428> decorationType, Consumer<class_2338> completionHandler) {
            this.dimension = dimension;
            this.scale = scale;
            this.decorationType = decorationType;
            this.completionHandler = completionHandler;
        }

        public MapLocationOperation(class_5321<class_1937> dimension, int scale, class_6880<class_9428> decorationType) {
            this(dimension, scale, decorationType, null);
        }

        public class_5321<class_1937> getDimension() {
            return this.dimension;
        }

        public int getScale() {
            return this.scale;
        }

        public class_6880<class_9428> getDecorationType() {
            return this.decorationType;
        }

        public Consumer<class_2338> getCompletionHandler() {
            return this.completionHandler;
        }
    }
}

