/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.AsyncMapTracker;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.platform.Services;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2595;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import net.minecraft.class_9428;

public class ExplorationMapFunctionLogic {
    private static final Cache<UUID, class_2561> MAP_NAME_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).build();

    private ExplorationMapFunctionLogic() {
    }

    public static void cacheName(class_1799 stack, class_2561 name) {
        if (name == null) {
            return;
        }
        UUID id = CommonLogic.getTrackingUUID(stack);
        if (id != null) {
            MAP_NAME_CACHE.put((Object)id, (Object)name);
            ALConstants.logDebug("Cached name for map UUID {}", id);
        } else {
            ALConstants.logWarn("Attempted to cache name for map without tracking UUID", new Object[0]);
        }
    }

    public static class_2561 getCachedName(class_1799 stack) {
        UUID id = CommonLogic.getTrackingUUID(stack);
        if (id == null) {
            return null;
        }
        class_2561 name = (class_2561)MAP_NAME_CACHE.getIfPresent((Object)id);
        if (name != null) {
            MAP_NAME_CACHE.invalidate((Object)id);
            ALConstants.logDebug("Retrieved and invalidated cached name for map UUID {}", id);
        }
        return name;
    }

    private static void processLocationResult(UUID trackingId, class_2338 foundLocation) {
        AsyncMapTracker.getInstance().completeLocationOperation(trackingId, foundLocation);
    }

    public static void handleLocationFound(class_1799 mapStack, class_3218 level, class_2338 pos, int scale, class_6880<class_9428> destinationTypeHolder, class_2338 invPos) {
        if (pos == null) {
            ALConstants.logInfo("No location found - invalidating map stack in inventory at {}", invPos);
            Services.EXPLORATION_MAP_FUNCTION_LOGIC.invalidateMap(mapStack, level, invPos);
        } else {
            ALConstants.logInfo("Location found at {} - updating treasure map in inventory at {}", pos, invPos);
            class_2561 mapName = ExplorationMapFunctionLogic.getCachedName(mapStack);
            Services.EXPLORATION_MAP_FUNCTION_LOGIC.updateMap(mapStack, level, pos, scale, destinationTypeHolder, invPos, mapName);
        }
    }

    public static class_1799 updateMapAsync(class_3218 level, class_2338 blockPos, int scale, int searchRadius, boolean skipKnownStructures, class_6880<class_9428> destinationTypeHolder, class_6862<class_3195> destination) {
        class_1799 mapStack = CommonLogic.createManagedMap();
        ALConstants.logDebug("Created managed map stack for async update (Search origin: {})", blockPos);
        class_9279 customData = (class_9279)mapStack.method_57824(class_9334.field_49628);
        if (customData != null) {
            UUID operationId = customData.method_57461().method_25926("asynclocator.pending.uuid");
            boolean isChestGenerated = level.method_8321(blockPos) instanceof class_2595;
            AsyncMapTracker.getInstance().addLocationOperation(operationId, new AsyncMapTracker.MapLocationOperation((class_5321<class_1937>)level.method_27983(), scale, destinationTypeHolder));
            AsyncLocator.locate(level, destination, blockPos, searchRadius, skipKnownStructures).thenOnServerThread(foundPos -> {
                if (isChestGenerated) {
                    ExplorationMapFunctionLogic.handleLocationFound(mapStack, level, foundPos, scale, destinationTypeHolder, blockPos);
                } else {
                    ExplorationMapFunctionLogic.processLocationResult(operationId, foundPos);
                }
            });
        }
        return mapStack;
    }
}

