/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.ALDataComponents;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.logic.ExplorationMapFunctionLogic;
import brightspark.asynclocator.platform.Services;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_111;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_47;
import net.minecraft.class_5321;
import net.minecraft.class_5341;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_9209;
import net.minecraft.class_9334;
import net.minecraft.class_9428;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_111.class})
public abstract class ExplorationMapFunctionMixin {
    @Shadow
    @Final
    class_6862<class_3195> field_1035;
    @Shadow
    @Final
    byte field_1037;
    @Shadow
    @Final
    int field_1032;
    @Shadow
    @Final
    boolean field_1033;
    @Unique
    private class_5321<class_9428> asyncLocator$decorationTypeKey;

    @Inject(method={"<init>(Ljava/util/List;Lnet/minecraft/tags/TagKey;Lnet/minecraft/core/Holder;BIZ)V"}, at={@At(value="RETURN")})
    private void captureDecorationKey(List<class_5341> conditions, class_6862<class_3195> dest, class_6880<class_9428> typeHolder, byte zm, int radius, boolean skip, CallbackInfo ci) {
        typeHolder.method_40230().ifPresentOrElse(key -> {
            this.asyncLocator$decorationTypeKey = key;
        }, () -> {
            ALConstants.logWarn("Failed to find registered key for MapDecorationType Holder {} in ExplorationMapFunction constructor", typeHolder);
            this.asyncLocator$decorationTypeKey = null;
        });
    }

    @Unique
    private Optional<class_6880<class_9428>> getDecorationHolderFromKey(class_47 context) {
        if (this.asyncLocator$decorationTypeKey == null) {
            return Optional.empty();
        }
        return context.method_299().method_30349().method_33310(class_7924.field_50082).flatMap(registry -> registry.method_40264(this.asyncLocator$decorationTypeKey));
    }

    @Redirect(method={"run(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/storage/loot/LootContext;)Lnet/minecraft/world/item/ItemStack;"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/item/MapItem;create(Lnet/minecraft/world/level/Level;IIBZZ)Lnet/minecraft/world/item/ItemStack;"))
    private class_1799 redirectMapItemCreate(class_1937 level, int x, int z, byte scale, boolean trackingPosition, boolean unlimitedTracking, class_1799 originalStack_usedByRun, class_47 context_usedByRun) {
        class_47 context = context_usedByRun;
        if (!Services.CONFIG.explorationMapEnabled() || !(level instanceof class_3218)) {
            return class_1806.method_8005((class_1937)level, (int)x, (int)z, (byte)scale, (boolean)trackingPosition, (boolean)unlimitedTracking);
        }
        class_3218 serverLevel = (class_3218)level;
        Optional<class_6880<class_9428>> mapDecorationHolderOpt = this.getDecorationHolderFromKey(context);
        if (mapDecorationHolderOpt.isEmpty()) {
            ALConstants.logError("ExplorationMap Redirect: Couldn't get MapDecorationType Holder for key {}, falling back to vanilla map creation.", this.asyncLocator$decorationTypeKey);
            return class_1806.method_8005((class_1937)level, (int)x, (int)z, (byte)scale, (boolean)trackingPosition, (boolean)unlimitedTracking);
        }
        ALConstants.logDebug("Redirecting MapItem.create for async locator exploration map {}.", this.field_1035.comp_327());
        class_2338 originPos = context.method_296(class_181.field_24424) != null ? class_2338.method_49638((class_2374)((class_2374)context.method_35508(class_181.field_24424))) : class_2338.method_49637((double)x, (double)(level.method_31605() / 2), (double)z);
        class_22 mapData = class_22.method_32363((double)0.0, (double)0.0, (byte)this.field_1037, (boolean)false, (boolean)false, (class_5321)serverLevel.method_27983());
        class_9209 newMapId = serverLevel.method_17889();
        serverLevel.method_17890(newMapId, mapData);
        ALConstants.logDebug("Saved initial MapItemSavedData for new MapId {} for exploration map.", newMapId);
        class_1799 pendingMapStack = CommonLogic.createManagedMap();
        pendingMapStack.method_57379(class_9334.field_49646, (Object)newMapId);
        ALConstants.logDebug("Assigned MapId {} to exploration map ItemStack.", newMapId);
        AsyncLocator.locate(serverLevel, this.field_1035, originPos, this.field_1032, this.field_1033).thenOnServerThread(foundPos -> {
            class_2338 inventoryPos;
            class_2561 mapName = ExplorationMapFunctionLogic.getCachedName(pendingMapStack);
            class_2338 class_23382 = inventoryPos = context.method_296(class_181.field_24424) != null ? class_2338.method_49638((class_2374)((class_2374)context.method_35508(class_181.field_24424))) : null;
            if (foundPos != null) {
                ALConstants.logInfo("Async location found for exploration map {}: {} -> Calling completion logic", this.field_1035.comp_327(), foundPos);
                CommonLogic.completeMapUpdate(pendingMapStack, serverLevel, foundPos, (class_6880<class_9428>)((class_6880)mapDecorationHolderOpt.get()), mapName);
            } else {
                ALConstants.logInfo("Async location not found for exploration map {} -> Invalidating map in inventory (if possible)", this.field_1035.comp_327());
                if (inventoryPos != null) {
                    Services.EXPLORATION_MAP_FUNCTION_LOGIC.invalidateMap(pendingMapStack, serverLevel, inventoryPos);
                } else {
                    ALConstants.logWarn("Cannot invalidate exploration map - LootContext lacks ORIGIN parameter.", new Object[0]);
                    pendingMapStack.method_57381(ALDataComponents.LOCATING);
                    pendingMapStack.method_57381(class_9334.field_50239);
                }
            }
        });
        return pendingMapStack;
    }
}

