/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.mixins.LocateCommandAccess;
import brightspark.asynclocator.platform.Services;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import net.minecraft.class_156;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2561;
import net.minecraft.class_3079;
import net.minecraft.class_3195;
import net.minecraft.class_6885;
import net.minecraft.class_7066;
import net.minecraft.class_7737;

public class LocateCommandLogic {
    private static final int BIOME_SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int BIOME_SAMPLE_RESOLUTION_VERTICAL = 64;

    private LocateCommandLogic() {
    }

    public static void locateAsync(class_2168 sourceStack, class_7066.class_7068<class_3195> structureResult, class_6885<class_3195> holderset) {
        class_2338 originPos = class_2338.method_49638((class_2374)sourceStack.method_9222());
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)class_156.field_37250);
        AsyncLocator.locate(sourceStack.method_9225(), holderset, originPos, 100, false).thenOnServerThread(pair -> {
            stopwatch.stop();
            if (pair != null) {
                ALConstants.logInfo("Location found - sending success back to command source", new Object[0]);
                class_3079.method_24499((class_2168)sourceStack, (class_7066.class_7068)structureResult, (class_2338)originPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
            } else {
                ALConstants.logInfo("No location found - sending failure back to command source", new Object[0]);
                sourceStack.method_9213((class_2561)class_2561.method_43470((String)LocateCommandAccess.getErrorFailed().create((Object)structureResult.method_41176()).getMessage()));
            }
        });
    }

    public static void locateBiomeAsync(class_2168 sourceStack, class_7737.class_7741<class_1959> biomeResult) {
        class_2338 originPos = class_2338.method_49638((class_2374)sourceStack.method_9222());
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)class_156.field_37250);
        int radius = Services.CONFIG.biomeSearchRadius();
        AsyncLocator.locateBiome(sourceStack.method_9225(), biomeResult, originPos, radius, 32, 64).thenOnServerThread(pair -> {
            stopwatch.stop();
            if (pair != null) {
                ALConstants.logInfo("Biome found - sending success back to command source", new Object[0]);
                class_3079.method_45148((class_2168)sourceStack, (class_7737.class_7741)biomeResult, (class_2338)originPos, (Pair)pair, (String)"commands.locate.biome.success", (boolean)true, (Duration)stopwatch.elapsed());
            } else {
                ALConstants.logInfo("Biome not found - sending failure back to command source", new Object[0]);
                sourceStack.method_9213((class_2561)class_2561.method_43470((String)LocateCommandAccess.getErrorBiomeNotFound().create((Object)biomeResult.method_45650()).getMessage()));
            }
        });
    }
}

