/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.logic.ExplorationMapFunctionLogic;
import brightspark.asynclocator.mixins.SetNameFunctionAccessor;
import brightspark.asynclocator.platform.Services;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_3670;
import net.minecraft.class_47;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3670.class})
public abstract class SetNameFunctionMixin {
    @Inject(method={"run(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/storage/loot/LootContext;)Lnet/minecraft/world/item/ItemStack;"}, at={@At(value="HEAD")}, cancellable=true)
    private void asyncLocator$cacheNameForPendingMap(class_1799 stack, class_47 context, CallbackInfoReturnable<class_1799> cir) {
        if (Services.CONFIG.explorationMapEnabled() && CommonLogic.isEmptyPendingMap(stack)) {
            class_2561 nameToSet = this.getNameFromSetNameFunction();
            if (nameToSet != null) {
                ALConstants.logDebug("SetNameFunctionMixin: Caching name '{}' for pending map and cancelling original set.", nameToSet.getString());
                ExplorationMapFunctionLogic.cacheName(stack, nameToSet);
                cir.setReturnValue((Object)stack);
            } else {
                ALConstants.logDebug("SetNameFunctionMixin: No direct name component found for pending map, letting original method run.", new Object[0]);
            }
        } else {
            ALConstants.logDebug("SetNameFunctionMixin: Not a pending map or feature disabled, letting original method run.", new Object[0]);
        }
    }

    private class_2561 getNameFromSetNameFunction() {
        try {
            SetNameFunctionAccessor accessor = (SetNameFunctionAccessor)((Object)this);
            return accessor.getName().orElse(null);
        }
        catch (Throwable t) {
            ALConstants.logWarn("Failed to access name via SetNameFunctionAccessor: {}", t.getMessage());
            return null;
        }
    }
}

