/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator;

import brightspark.asynclocator.ALConstants;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AsyncLocatorConfigNeoForge {
    private static final int DEFAULT_THREADS = 1;
    private static final int MAX_THREADS = 64;
    private static final int DEFAULT_BIOME_RADIUS = 6400;
    private static final int MIN_BIOME_RADIUS = 1600;
    private static final int MAX_BIOME_RADIUS = 12800;
    public static ModConfigSpec SPEC;
    public static ModConfigSpec.ConfigValue<Integer> LOCATOR_THREADS;
    public static ModConfigSpec.ConfigValue<Integer> BIOME_SEARCH_RADIUS;
    public static ModConfigSpec.ConfigValue<Boolean> REMOVE_OFFER;
    public static ModConfigSpec.ConfigValue<Boolean> DOLPHIN_TREASURE_ENABLED;
    public static ModConfigSpec.ConfigValue<Boolean> EYE_OF_ENDER_ENABLED;
    public static ModConfigSpec.ConfigValue<Boolean> EXPLORATION_MAP_ENABLED;
    public static ModConfigSpec.ConfigValue<Boolean> LOCATE_COMMAND_ENABLED;
    public static ModConfigSpec.ConfigValue<Boolean> LOCATE_BIOME_COMMAND_ENABLED;
    public static ModConfigSpec.ConfigValue<Boolean> VILLAGER_TRADE_ENABLED;

    public static void validateConfig() {
        int biomeRadius;
        boolean needsSave = false;
        int threads = (Integer)LOCATOR_THREADS.get();
        if (threads < 1 || threads > 64) {
            ALConstants.logError("Invalid locatorThreads value ({}). Must be between 1-64. Resetting to default ({}).", threads, 64, 1);
            LOCATOR_THREADS.set((Object)1);
            needsSave = true;
        }
        if ((biomeRadius = ((Integer)BIOME_SEARCH_RADIUS.get()).intValue()) < 1600 || biomeRadius > 12800) {
            ALConstants.logError("Invalid biomeSearchRadius value ({}). Must be between {}-{}. Resetting to default ({}).", biomeRadius, 1600, 12800, 6400);
            BIOME_SEARCH_RADIUS.set((Object)6400);
            needsSave = true;
        }
        if (needsSave) {
            SPEC.save();
            ALConstants.logInfo("Config values corrected and saved", new Object[0]);
        }
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        LOCATOR_THREADS = builder.worldRestart().comment(new String[]{"The maximum number of threads in the async locator thread pool.", "There's an upper limit of 64. This should only be increased if you're experiencing", "simultaneous location lookups causing issues AND you have the hardware capable of handling", "the extra possible threads.", "The default of 1 should be suitable for most users.", "This value must not exceed 64."}).define("asyncLocatorThreads", (Object)1, value -> {
            if (!(value instanceof Integer)) {
                return false;
            }
            Integer intValue = (Integer)value;
            return intValue >= 1 && intValue <= 64;
        });
        BIOME_SEARCH_RADIUS = builder.comment(new String[]{"Maximum search radius in blocks for /locate biome command.", "The vanilla value is 6400.", "It is not recommended to change the value unless you want to test something or have some issue."}).defineInRange("biomeSearchRadius", 6400, 1600, 12800);
        REMOVE_OFFER = builder.comment(new String[]{"When a merchant's treasure map offer ends up not finding a feature location,", "remove the offer instead of marking it out of stock."}).define("removeMerchantInvalidMapOffer", false);
        builder.push("Feature Toggles");
        DOLPHIN_TREASURE_ENABLED = builder.comment("If true, enables asynchronous locating of structures for dolphin treasures.").define("dolphinTreasureEnabled", true);
        EYE_OF_ENDER_ENABLED = builder.comment("If true, enables asynchronous locating of structures when Eyes Of Ender are thrown.").define("eyeOfEnderEnabled", true);
        EXPLORATION_MAP_ENABLED = builder.comment("If true, enables asynchronous locating of structures for exploration maps found in chests.").define("explorationMapEnabled", true);
        LOCATE_COMMAND_ENABLED = builder.comment("If true, enables asynchronous locating of structures for the locate command.").define("locateCommandEnabled", true);
        LOCATE_BIOME_COMMAND_ENABLED = builder.comment("If true, enables asynchronous locating of biomes for the locate command.").define("locateBiomeCommandEnabled", true);
        VILLAGER_TRADE_ENABLED = builder.comment("If true, enables asynchronous locating of structures for villager trades.").define("villagerTradeEnabled", true);
        builder.pop();
        SPEC = builder.build();
    }
}

