/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALDataComponents;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Unit;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapId;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import org.jetbrains.annotations.Nullable;

public class CommonLogic {
    private static final String MAP_HOVER_NAME_KEY = "menu.working";
    private static final String PENDING_MARKER = "asynclocator.pending";
    private static final String UUID_TRACKER = "asynclocator.pending.uuid";

    private CommonLogic() {
    }

    public static ItemStack createEmptyMap() {
        ItemStack stack = new ItemStack((ItemLike)Items.FILLED_MAP);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)MAP_HOVER_NAME_KEY));
        CompoundTag customData = new CompoundTag();
        customData.putByte(PENDING_MARKER, (byte)1);
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
        return stack;
    }

    public static ItemStack createManagedMap() {
        ItemStack stack = new ItemStack((ItemLike)Items.FILLED_MAP);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)MAP_HOVER_NAME_KEY));
        CompoundTag customData = new CompoundTag();
        customData.putUUID(UUID_TRACKER, UUID.randomUUID());
        stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)customData));
        return stack;
    }

    public static ItemStack createMerchantMap(ServerLevel level) {
        ItemStack stack = new ItemStack((ItemLike)Items.FILLED_MAP);
        MapItemSavedData mapData = MapItemSavedData.createFresh((double)0.0, (double)0.0, (byte)2, (boolean)true, (boolean)true, (ResourceKey)level.dimension());
        MapId newMapId = level.getFreeMapId();
        stack.set(DataComponents.MAP_ID, (Object)newMapId);
        level.setMapData(newMapId, mapData);
        stack.set(DataComponents.ITEM_NAME, (Object)Component.translatable((String)MAP_HOVER_NAME_KEY));
        stack.set(ALDataComponents.LOCATING, (Object)Unit.INSTANCE);
        return stack;
    }

    public static boolean isEmptyPendingMap(ItemStack stack) {
        if (!stack.is(Items.FILLED_MAP)) {
            return false;
        }
        if (stack.has(ALDataComponents.LOCATING)) {
            return true;
        }
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return false;
        }
        return customData.contains(PENDING_MARKER) || customData.contains(UUID_TRACKER);
    }

    @Nullable
    public static UUID getTrackingUUID(ItemStack stack) {
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            return null;
        }
        CompoundTag tag = customData.copyTag();
        return tag.hasUUID(UUID_TRACKER) ? tag.getUUID(UUID_TRACKER) : null;
    }

    public static void clearPendingState(ItemStack mapStack) {
        mapStack.remove(ALDataComponents.LOCATING);
        CustomData currentData = (CustomData)mapStack.get(DataComponents.CUSTOM_DATA);
        if (currentData != null) {
            CompoundTag newTag = currentData.copyTag();
            newTag.remove(PENDING_MARKER);
            newTag.remove(UUID_TRACKER);
            if (newTag.isEmpty()) {
                mapStack.remove(DataComponents.CUSTOM_DATA);
            } else {
                mapStack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)newTag));
            }
        }
    }

    public static void finalizeMap(ItemStack mapStack, ServerLevel level, BlockPos pos, int scale, Holder<MapDecorationType> destinationType, @Nullable Component displayName) {
        MapId existingId = (MapId)mapStack.get(DataComponents.MAP_ID);
        MapId mapId = existingId != null ? existingId : level.getFreeMapId();
        MapItemSavedData mapData = MapItemSavedData.createFresh((double)pos.getX(), (double)pos.getZ(), (byte)((byte)scale), (boolean)true, (boolean)true, (ResourceKey)level.dimension());
        level.setMapData(mapId, mapData);
        if (existingId == null) {
            mapStack.set(DataComponents.MAP_ID, (Object)mapId);
        }
        MapItem.renderBiomePreviewMap((ServerLevel)level, (ItemStack)mapStack);
        MapItemSavedData.addTargetDecoration((ItemStack)mapStack, (BlockPos)pos, (String)"+", destinationType);
        if (displayName != null) {
            mapStack.set(DataComponents.ITEM_NAME, (Object)displayName);
        }
        CommonLogic.clearPendingState(mapStack);
    }

    public static void completeMapUpdate(ItemStack mapStack, ServerLevel level, BlockPos pos, Holder<MapDecorationType> destinationTypeHolder, @Nullable Component displayName) {
        CommonLogic.finalizeMap(mapStack, level, pos, 2, destinationTypeHolder, displayName);
    }

    public static void broadcastChestChanges(ServerLevel level, BlockEntity be) {
        if (!(be instanceof ChestBlockEntity)) {
            return;
        }
        ChestBlockEntity chestBE = (ChestBlockEntity)be;
        level.players().forEach(player -> {
            ChestMenu chestMenu;
            AbstractContainerMenu container = player.containerMenu;
            if (container instanceof ChestMenu && (chestMenu = (ChestMenu)container).getContainer() == chestBE) {
                chestMenu.broadcastChanges();
            }
        });
    }

    public static void broadcastContainerChanges(ServerLevel level, BlockEntity be, Container container) {
        level.players().forEach(player -> {
            ChestMenu chestMenu;
            AbstractContainerMenu menu = player.containerMenu;
            if (menu instanceof ChestMenu && (chestMenu = (ChestMenu)menu).getContainer() == container) {
                chestMenu.broadcastChanges();
            }
        });
    }
}

