/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.logic.CommonLogic;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.Duration;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;

public class ExplorationMapFunctionLogic {
    private static final Cache<UUID, Component> MAP_NAME_CACHE = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).maximumSize(3000L).build();

    private ExplorationMapFunctionLogic() {
    }

    public static void cacheName(ItemStack stack, Component name) {
        if (name == null) {
            return;
        }
        UUID id = CommonLogic.getTrackingUUID(stack);
        if (id != null) {
            MAP_NAME_CACHE.put((Object)id, (Object)name);
            ALConstants.logDebug("Cached name for map UUID {}", id);
        } else {
            ALConstants.logWarn("Attempted to cache name for map without tracking UUID", new Object[0]);
        }
    }

    public static Component getCachedName(ItemStack stack) {
        UUID id = CommonLogic.getTrackingUUID(stack);
        if (id == null) {
            return null;
        }
        Component name = (Component)MAP_NAME_CACHE.getIfPresent((Object)id);
        if (name != null) {
            MAP_NAME_CACHE.invalidate((Object)id);
            ALConstants.logDebug("Retrieved and invalidated cached name for map UUID {}", id);
        }
        return name;
    }
}

