/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator;

import brightspark.asynclocator.ALConstants;
import net.neoforged.neoforge.common.ModConfigSpec;

public class AsyncLocatorConfigNeoForge {
    private static final int DEFAULT_THREADS = 1;
    private static final int MAX_THREADS = 64;
    public static ModConfigSpec SPEC;
    public static ModConfigSpec.ConfigValue<Integer> LOCATOR_THREADS;
    public static ModConfigSpec.ConfigValue<Boolean> REMOVE_OFFER;
    public static ModConfigSpec.ConfigValue<Boolean> DOLPHIN_TREASURE_ENABLED;
    public static ModConfigSpec.ConfigValue<Boolean> EYE_OF_ENDER_ENABLED;
    public static ModConfigSpec.ConfigValue<Boolean> EXPLORATION_MAP_ENABLED;
    public static ModConfigSpec.ConfigValue<Boolean> LOCATE_COMMAND_ENABLED;
    public static ModConfigSpec.ConfigValue<Boolean> VILLAGER_TRADE_ENABLED;

    public static void validateConfig() {
        int threads = (Integer)LOCATOR_THREADS.get();
        if (threads < 1 || threads > 64) {
            ALConstants.logError("Invalid locatorThreads value ({}). Must be between 1-64. Resetting to default ({}).", threads);
            LOCATOR_THREADS.set((Object)1);
            LOCATOR_THREADS.save();
        }
    }

    static {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        LOCATOR_THREADS = builder.worldRestart().comment(new String[]{"The maximum number of threads in the async locator thread pool.", "There's an upper limit of 64. This should only be increased if you're experiencing", "simultaneous location lookups causing issues AND you have the hardware capable of handling", "the extra possible threads.", "The default of 1 should be suitable for most users.", "This value must not exceed 64."}).define("asyncLocatorThreads", (Object)1, value -> {
            if (!(value instanceof Integer)) {
                return false;
            }
            Integer intValue = (Integer)value;
            return intValue >= 1 && intValue <= 64;
        });
        REMOVE_OFFER = builder.comment(new String[]{"When a merchant's treasure map offer ends up not finding a feature location,", "remove the offer instead of marking it out of stock."}).define("removeMerchantInvalidMapOffer", false);
        builder.push("Feature Toggles");
        DOLPHIN_TREASURE_ENABLED = builder.comment("If true, enables asynchronous locating of structures for dolphin treasures.").define("dolphinTreasureEnabled", true);
        EYE_OF_ENDER_ENABLED = builder.comment("If true, enables asynchronous locating of structures when Eyes Of Ender are thrown.").define("eyeOfEnderEnabled", true);
        EXPLORATION_MAP_ENABLED = builder.comment("If true, enables asynchronous locating of structures for exploration maps found in chests.").define("explorationMapEnabled", true);
        LOCATE_COMMAND_ENABLED = builder.comment("If true, enables asynchronous locating of structures for the locate command.").define("locateCommandEnabled", true);
        VILLAGER_TRADE_ENABLED = builder.comment("If true, enables asynchronous locating of structures for villager trades.").define("villagerTradeEnabled", true);
        builder.pop();
        SPEC = builder.build();
    }
}

