/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.platform.Services;
import com.mojang.datafixers.util.Pair;
import java.text.NumberFormat;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.levelgen.structure.Structure;

public class AsyncLocator {
    private static volatile ExecutorService LOCATING_EXECUTOR_SERVICE = null;
    private static final AtomicInteger POOL_COUNTER = new AtomicInteger(1);

    private AsyncLocator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setupExecutorService() {
        Class<AsyncLocator> clazz = AsyncLocator.class;
        synchronized (AsyncLocator.class) {
            AsyncLocator.shutdownExecutorService();
            int threads = Services.CONFIG.locatorThreads();
            if (threads <= 0) {
                ALConstants.logWarn("Configured locatorThreads <= 0 ({}). Falling back to 1 thread", threads);
                threads = 1;
            }
            ALConstants.logInfo("Starting locating executor service with thread pool size of {}", threads);
            String namePrefix = "asynclocator-" + POOL_COUNTER.getAndIncrement() + "-thread-";
            AtomicInteger threadNum = new AtomicInteger(1);
            LOCATING_EXECUTOR_SERVICE = Executors.newFixedThreadPool(threads, r -> {
                Thread t = new Thread(r, namePrefix + threadNum.getAndIncrement());
                t.setDaemon(true);
                t.setUncaughtExceptionHandler((th, e) -> ALConstants.logError(e, "Uncaught exception in locating thread {}", th.getName()));
                return t;
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownExecutorService() {
        Class<AsyncLocator> clazz = AsyncLocator.class;
        synchronized (AsyncLocator.class) {
            if (LOCATING_EXECUTOR_SERVICE != null) {
                ALConstants.logInfo("Shutting down locating executor service", new Object[0]);
                LOCATING_EXECUTOR_SERVICE.shutdown();
                try {
                    if (!LOCATING_EXECUTOR_SERVICE.awaitTermination(5L, TimeUnit.SECONDS)) {
                        LOCATING_EXECUTOR_SERVICE.shutdownNow();
                    }
                }
                catch (InterruptedException ie) {
                    LOCATING_EXECUTOR_SERVICE.shutdownNow();
                    Thread.currentThread().interrupt();
                }
                LOCATING_EXECUTOR_SERVICE = null;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isExecutorActive() {
        ExecutorService es = LOCATING_EXECUTOR_SERVICE;
        return es != null && !es.isShutdown() && !es.isTerminated();
    }

    public static LocateTask<BlockPos> locate(ServerLevel level, TagKey<Structure> structureTag, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        ALConstants.logDebug("Creating locate task for {} in {} around {} within {} chunks", structureTag, level, pos, searchRadius);
        if (!AsyncLocator.isExecutorActive()) {
            ALConstants.logWarn("Locating executor service not initialized or not active: creating lazily", new Object[0]);
            AsyncLocator.setupExecutorService();
        }
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateLevel(completableFuture, level, structureTag, pos, searchRadius, skipKnownStructures));
        return new LocateTask<BlockPos>(level.getServer(), completableFuture, future);
    }

    public static LocateTask<Pair<BlockPos, Holder<Structure>>> locate(ServerLevel level, HolderSet<Structure> structureSet, BlockPos pos, int searchRadius, boolean skipKnownStructures) {
        ALConstants.logDebug("Creating locate task for {} in {} around {} within {} chunks", structureSet, level, pos, searchRadius);
        if (!AsyncLocator.isExecutorActive()) {
            ALConstants.logWarn("Locating executor service not initialized or not active: creating lazily", new Object[0]);
            AsyncLocator.setupExecutorService();
        }
        CompletableFuture completableFuture = new CompletableFuture();
        Future<?> future = LOCATING_EXECUTOR_SERVICE.submit(() -> AsyncLocator.doLocateChunkGenerator(completableFuture, level, structureSet, pos, searchRadius, skipKnownStructures));
        return new LocateTask<Pair<BlockPos, Holder<Structure>>>(level.getServer(), completableFuture, future);
    }

    private static void doLocateLevel(CompletableFuture<BlockPos> completableFuture, ServerLevel level, TagKey<Structure> structureTag, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        try {
            ALConstants.logDebug("Trying to locate {} in {} around {} within {} chunks", structureTag, level, pos, searchRadius);
            long start = System.nanoTime();
            BlockPos foundPos = level.findNearestMapStructure(structureTag, pos, searchRadius, skipExistingChunks);
            String time = NumberFormat.getNumberInstance().format(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            if (foundPos == null) {
                ALConstants.logInfo("No {} found (took {}ms)", structureTag, time);
            } else {
                ALConstants.logInfo("Found {} at {} (took {}ms)", structureTag, foundPos, time);
            }
            completableFuture.complete(foundPos);
        }
        catch (Throwable t) {
            ALConstants.logError(t, "Exception while locating {} around {}", structureTag, pos);
            try {
                completableFuture.complete(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void doLocateChunkGenerator(CompletableFuture<Pair<BlockPos, Holder<Structure>>> completableFuture, ServerLevel level, HolderSet<Structure> structureSet, BlockPos pos, int searchRadius, boolean skipExistingChunks) {
        try {
            ALConstants.logDebug("Trying to locate {} in {} around {} within {} chunks", structureSet, level, pos, searchRadius);
            long start = System.nanoTime();
            Pair foundPair = level.getChunkSource().getGenerator().findNearestMapStructure(level, structureSet, pos, searchRadius, skipExistingChunks);
            String time = NumberFormat.getNumberInstance().format(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start));
            if (foundPair == null) {
                ALConstants.logInfo("No {} found (took {}ms)", structureSet, time);
            } else {
                ALConstants.logInfo("Found {} at {} (took {}ms)", ((Structure)((Holder)foundPair.getSecond()).value()).getClass().getSimpleName(), foundPair.getFirst(), time);
            }
            completableFuture.complete((Pair<BlockPos, Holder<Structure>>)foundPair);
        }
        catch (Throwable t) {
            ALConstants.logError(t, "Exception while locating {} around {}", structureSet, pos);
            try {
                completableFuture.complete(null);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public record LocateTask<T>(MinecraftServer server, CompletableFuture<T> completableFuture, Future<?> taskFuture) {
        public LocateTask<T> then(Consumer<T> action) {
            this.completableFuture.thenAccept((Consumer)action);
            return this;
        }

        public LocateTask<T> thenOnServerThread(Consumer<T> action) {
            this.completableFuture.thenAccept(pos -> this.server.submit(() -> action.accept(pos)));
            return this;
        }

        public void cancel() {
            this.taskFuture.cancel(true);
            this.completableFuture.cancel(false);
        }
    }
}

