/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.mixins.LocateCommandAccess;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.world.level.levelgen.structure.Structure;

public class LocateCommandLogic {
    private LocateCommandLogic() {
    }

    public static void locateAsync(CommandSourceStack sourceStack, ResourceOrTagKeyArgument.Result<Structure> structureResult, HolderSet<Structure> holderset) {
        BlockPos originPos = BlockPos.containing((Position)sourceStack.getPosition());
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
        AsyncLocator.locate(sourceStack.getLevel(), holderset, originPos, 100, false).thenOnServerThread(pair -> {
            stopwatch.stop();
            if (pair != null) {
                ALConstants.logInfo("Location found - sending success back to command source", new Object[0]);
                LocateCommand.showLocateResult((CommandSourceStack)sourceStack, (ResourceOrTagKeyArgument.Result)structureResult, (BlockPos)originPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
            } else {
                ALConstants.logInfo("No location found - sending failure back to command source", new Object[0]);
                sourceStack.sendFailure((Component)Component.literal((String)LocateCommandAccess.getErrorFailed().create((Object)structureResult.asPrintable()).getMessage()));
            }
        });
    }
}

