/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.AsyncLocatorConfigNeoForge;
import brightspark.asynclocator.AsyncLocatorModCommon;
import brightspark.asynclocator.NeoForgeDataComponents;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.NeoForge;

@Mod(value="asynclocator")
public class AsyncLocatorModNeoForge {
    public AsyncLocatorModNeoForge(IEventBus modEventBus, ModContainer modContainer) {
        NeoForgeDataComponents.register(modEventBus);
        modContainer.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)AsyncLocatorConfigNeoForge.SPEC, "asynclocator.toml");
        modEventBus.addListener(event -> {
            if (event.getConfig().getSpec() == AsyncLocatorConfigNeoForge.SPEC) {
                AsyncLocatorConfigNeoForge.validateConfig();
                AsyncLocatorModCommon.printConfigs();
            }
        });
        modEventBus.addListener(event -> {
            if (event.getConfig().getSpec() == AsyncLocatorConfigNeoForge.SPEC) {
                ALConstants.logInfo("Config reloaded", new Object[0]);
                AsyncLocatorConfigNeoForge.validateConfig();
                AsyncLocatorModCommon.printConfigs();
                if (AsyncLocator.isExecutorActive()) {
                    AsyncLocator.setupExecutorService();
                }
            }
        });
        IEventBus neoforgeEventBus = NeoForge.EVENT_BUS;
        neoforgeEventBus.addListener(event -> AsyncLocator.setupExecutorService());
        neoforgeEventBus.addListener(event -> AsyncLocator.shutdownExecutorService());
    }
}

