/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.logic.EyeOfEnderData;
import com.mojang.datafixers.util.Pair;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.tags.StructureTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.EyeOfEnder;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.levelgen.structure.Structure;

public class EnderEyeItemLogic {
    private EnderEyeItemLogic() {
    }

    public static void locateAsync(ServerLevel level, Player player, EyeOfEnder eyeOfEnder, EnderEyeItem enderEyeItem) {
        long timeoutSeconds = 20L;
        try {
            Registry registry = level.registryAccess().lookupOrThrow(Registries.STRUCTURE);
            Optional optionalSet = registry.get(StructureTags.EYE_OF_ENDER_LOCATED);
            if (optionalSet.isPresent()) {
                HolderSet holderSet = (HolderSet)optionalSet.get();
                ((EyeOfEnderData)eyeOfEnder).setLocateTaskOngoing(true);
                AsyncLocator.LocateTask<Pair<BlockPos, Holder<Structure>>> locateTask = AsyncLocator.locate(level, (HolderSet<Structure>)holderSet, player.blockPosition(), 100, false);
                CompletableFuture<Pair<BlockPos, Holder<Structure>>> timed = locateTask.completableFuture().orTimeout(20L, TimeUnit.SECONDS);
                timed.whenComplete((pair, throwable) -> locateTask.server().submit(() -> {
                    ((EyeOfEnderData)eyeOfEnder).setLocateTaskOngoing(false);
                    if (!eyeOfEnder.isAlive() || eyeOfEnder.isRemoved()) {
                        ALConstants.logDebug("EyeOfEnder no longer alive when locate result arrived", new Object[0]);
                        return;
                    }
                    if (throwable instanceof TimeoutException) {
                        ALConstants.logWarn("EyeOfEnder locate timed out after {}s, dropping item and removing entity", 20L);
                        try {
                            locateTask.cancel();
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                        ItemEntity drop = new ItemEntity((Level)level, eyeOfEnder.getX(), eyeOfEnder.getY(), eyeOfEnder.getZ(), new ItemStack((ItemLike)Items.ENDER_EYE));
                        level.addFreshEntity((Entity)drop);
                        eyeOfEnder.discard();
                        return;
                    }
                    if (throwable != null) {
                        ALConstants.logError(throwable, "Exception while locating using HolderSet for EyeOfEnder", new Object[0]);
                        ALConstants.logInfo("No location found - removing eye of ender entity", new Object[0]);
                        eyeOfEnder.discard();
                        return;
                    }
                    if (pair != null) {
                        ALConstants.logInfo("Location found - updating eye of ender entity (structure: {})", ((Structure)((Holder)pair.getSecond()).value()).getClass().getSimpleName());
                        try {
                            eyeOfEnder.signalTo((BlockPos)pair.getFirst());
                        }
                        catch (Throwable t) {
                            ALConstants.logError(t, "Failed to signal EyeOfEnder to position {}", pair.getFirst());
                        }
                        if (player instanceof ServerPlayer) {
                            ServerPlayer sp = (ServerPlayer)player;
                            CriteriaTriggers.USED_ENDER_EYE.trigger(sp, (BlockPos)pair.getFirst());
                        }
                        player.awardStat(Stats.ITEM_USED.get((Object)enderEyeItem));
                    } else {
                        ALConstants.logInfo("No location found - removing eye of ender entity", new Object[0]);
                        eyeOfEnder.discard();
                    }
                }));
                return;
            }
            ALConstants.logWarn("EYE_OF_ENDER_LOCATED tag not found in structure registry", new Object[0]);
        }
        catch (Throwable t) {
            ALConstants.logError(t, "Failed to resolve HolderSet for EYE_OF_ENDER_LOCATED", new Object[0]);
        }
        ((EyeOfEnderData)eyeOfEnder).setLocateTaskOngoing(true);
        AsyncLocator.LocateTask<BlockPos> locateTask = AsyncLocator.locate(level, (TagKey<Structure>)StructureTags.EYE_OF_ENDER_LOCATED, player.blockPosition(), 100, false);
        CompletableFuture<BlockPos> timed = locateTask.completableFuture().orTimeout(20L, TimeUnit.SECONDS);
        timed.whenComplete((pos, throwable) -> locateTask.server().submit(() -> {
            ((EyeOfEnderData)eyeOfEnder).setLocateTaskOngoing(false);
            if (!eyeOfEnder.isAlive() || eyeOfEnder.isRemoved()) {
                ALConstants.logDebug("EyeOfEnder no longer alive when locate result arrived", new Object[0]);
                return;
            }
            if (throwable instanceof TimeoutException) {
                ALConstants.logWarn("EyeOfEnder locate timed out after {}s, dropping item and removing entity", 20L);
                try {
                    locateTask.cancel();
                }
                catch (Throwable throwable2) {
                    // empty catch block
                }
                ItemEntity drop = new ItemEntity((Level)level, eyeOfEnder.getX(), eyeOfEnder.getY(), eyeOfEnder.getZ(), new ItemStack((ItemLike)Items.ENDER_EYE));
                level.addFreshEntity((Entity)drop);
                eyeOfEnder.discard();
                return;
            }
            if (throwable != null) {
                ALConstants.logError(throwable, "Exception while locating using TagKey for EyeOfEnder", new Object[0]);
                ALConstants.logInfo("No location found - removing eye of ender entity", new Object[0]);
                eyeOfEnder.discard();
                return;
            }
            if (pos != null) {
                ALConstants.logInfo("Location found - updating eye of ender entity", new Object[0]);
                try {
                    eyeOfEnder.signalTo(pos);
                }
                catch (Throwable t2) {
                    ALConstants.logError(t2, "Failed to signal EyeOfEnder to position {}", pos);
                }
                if (player instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)player;
                    CriteriaTriggers.USED_ENDER_EYE.trigger(sp, pos);
                }
                player.awardStat(Stats.ITEM_USED.get((Object)enderEyeItem));
            } else {
                ALConstants.logInfo("No location found - removing eye of ender entity", new Object[0]);
                eyeOfEnder.discard();
            }
        }));
    }
}

