/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.logic;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.mixins.LocateCommandAccess;
import brightspark.asynclocator.platform.Services;
import com.google.common.base.Stopwatch;
import com.google.common.base.Ticker;
import com.mojang.datafixers.util.Pair;
import java.time.Duration;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.ResourceOrTagArgument;
import net.minecraft.commands.arguments.ResourceOrTagKeyArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.LocateCommand;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.structure.Structure;

public class LocateCommandLogic {
    private static final int BIOME_SAMPLE_RESOLUTION_HORIZONTAL = 32;
    private static final int BIOME_SAMPLE_RESOLUTION_VERTICAL = 64;

    private LocateCommandLogic() {
    }

    public static void locateAsync(CommandSourceStack sourceStack, ResourceOrTagKeyArgument.Result<Structure> structureResult, HolderSet<Structure> holderset) {
        BlockPos originPos = BlockPos.containing((Position)sourceStack.getPosition());
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
        AsyncLocator.locate(sourceStack.getLevel(), holderset, originPos, 100, false).thenOnServerThread(pair -> {
            stopwatch.stop();
            if (pair != null) {
                ALConstants.logInfo("Location found - sending success back to command source", new Object[0]);
                LocateCommand.showLocateResult((CommandSourceStack)sourceStack, (ResourceOrTagKeyArgument.Result)structureResult, (BlockPos)originPos, (Pair)pair, (String)"commands.locate.structure.success", (boolean)false, (Duration)stopwatch.elapsed());
            } else {
                ALConstants.logInfo("No location found - sending failure back to command source", new Object[0]);
                sourceStack.sendFailure((Component)Component.literal((String)LocateCommandAccess.getErrorFailed().create((Object)structureResult.asPrintable()).getMessage()));
            }
        });
    }

    public static void locateBiomeAsync(CommandSourceStack sourceStack, ResourceOrTagArgument.Result<Biome> biomeResult) {
        BlockPos originPos = BlockPos.containing((Position)sourceStack.getPosition());
        Stopwatch stopwatch = Stopwatch.createStarted((Ticker)Util.TICKER);
        int radius = Services.CONFIG.biomeSearchRadius();
        AsyncLocator.locateBiome(sourceStack.getLevel(), biomeResult, originPos, radius, 32, 64).thenOnServerThread(pair -> {
            stopwatch.stop();
            if (pair != null) {
                ALConstants.logInfo("Biome found - sending success back to command source", new Object[0]);
                LocateCommand.showLocateResult((CommandSourceStack)sourceStack, (ResourceOrTagArgument.Result)biomeResult, (BlockPos)originPos, (Pair)pair, (String)"commands.locate.biome.success", (boolean)true, (Duration)stopwatch.elapsed());
            } else {
                ALConstants.logInfo("Biome not found - sending failure back to command source", new Object[0]);
                sourceStack.sendFailure((Component)Component.literal((String)LocateCommandAccess.getErrorBiomeNotFound().create((Object)biomeResult.asPrintable()).getMessage()));
            }
        });
    }
}

