/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.platform;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.platform.services.ExplorationMapFunctionLogicHelper;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_9428;
import org.jetbrains.annotations.Nullable;

public class FabricExplorationMapFunctionLogicHelper
implements ExplorationMapFunctionLogicHelper {
    @Override
    public void invalidateMap(class_1799 mapStack, class_3218 level, class_2338 invPos) {
        FabricExplorationMapFunctionLogicHelper.handleUpdateMapInChest(mapStack, level, invPos, (chest, slot) -> {
            ALConstants.logDebug("Invalidating map in Fabric inventory slot {}", slot);
            chest.method_5447(slot.intValue(), new class_1799((class_1935)class_1802.field_8895));
        });
    }

    @Override
    public void updateMap(class_1799 mapStack, class_3218 level, class_2338 pos, int scale, class_6880<class_9428> destinationTypeHolder, class_2338 invPos, @Nullable class_2561 displayName) {
        CommonLogic.finalizeMap(mapStack, level, pos, scale, destinationTypeHolder, displayName);
        FabricExplorationMapFunctionLogicHelper.handleUpdateMapInChest(mapStack, level, invPos, (chest, slot) -> {
            ALConstants.logDebug("Updated map in Fabric inventory slot {}, broadcasting changes.", slot);
            chest.method_5447(slot.intValue(), mapStack);
        });
    }

    private static void handleUpdateMapInChest(class_1799 mapStackToFind, class_3218 level, class_2338 inventoryPos, BiConsumer<class_2595, Integer> handleSlotFound) {
        class_2586 be = level.method_8321(inventoryPos);
        if (be instanceof class_2595) {
            class_2595 chest = (class_2595)be;
            boolean found = false;
            UUID targetId = CommonLogic.getTrackingUUID(mapStackToFind);
            for (int i = 0; i < chest.method_5439(); ++i) {
                class_1799 slotStack = chest.method_5438(i);
                UUID slotId = CommonLogic.getTrackingUUID(slotStack);
                if (targetId == null || !targetId.equals(slotId)) continue;
                handleSlotFound.accept(chest, i);
                CommonLogic.broadcastChestChanges(level, be);
                found = true;
                break;
            }
            if (!found) {
                ALConstants.logWarn("Could not find the specific map ItemStack instance in ChestBE at {}", inventoryPos);
            }
        } else {
            ALConstants.logWarn("No ChestBlockEntity at inventory position {} in level {}", inventoryPos, level.method_27983().method_29177());
        }
    }
}

