/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.SparkConfig;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import net.fabricmc.loader.api.FabricLoader;

public class AsyncLocatorConfigFabric {
    private static final int DEFAULT_THREADS = 1;
    private static final int MAX_THREADS = 64;
    @SparkConfig.Config(value="asyncLocatorThreads", comment="The maximum number of threads in the async locator thread pool.\nThere's an upper limit of 64. This should only be increased if you're experiencing\nsimultaneous location lookups causing issues AND you have the hardware capable of handling\nthe extra possible threads.\nThe default of 1 should be suitable for most users.\nThis value must not exceed 64.\n", min=1.0f, max=64.0f)
    public static int LOCATOR_THREADS = 1;
    @SparkConfig.Config(value="removeMerchantInvalidMapOffer", comment="When a merchant's treasure map offer ends up not finding a feature location,\nwhether the offer should be removed or marked as out of stock.\n")
    public static boolean REMOVE_OFFER = false;

    private AsyncLocatorConfigFabric() {
    }

    private static void resetToDefaults() {
        LOCATOR_THREADS = 1;
        REMOVE_OFFER = false;
        FeatureToggles.DOLPHIN_TREASURE_ENABLED = true;
        FeatureToggles.EYE_OF_ENDER_ENABLED = true;
        FeatureToggles.EXPLORATION_MAP_ENABLED = true;
        FeatureToggles.LOCATE_COMMAND_ENABLED = true;
        FeatureToggles.VILLAGER_TRADE_ENABLED = true;
    }

    public static void init() {
        block12: {
            Path configFile = FabricLoader.getInstance().getConfigDir().resolve("asynclocator.properties");
            if (Files.exists(configFile, new LinkOption[0])) {
                ALConstants.logInfo("Config file found", new Object[0]);
                try {
                    SparkConfig.read(configFile, AsyncLocatorConfigFabric.class);
                    if (LOCATOR_THREADS <= 64 && LOCATOR_THREADS >= 1) break block12;
                    ALConstants.logError("Invalid locatorThreads value ({}). Must be between 1-64. Resetting to default ({}).", LOCATOR_THREADS, 1);
                    LOCATOR_THREADS = 1;
                    try {
                        SparkConfig.write(configFile, AsyncLocatorConfigFabric.class);
                        ALConstants.logInfo("Config file rewritten with default threads value", new Object[0]);
                    }
                    catch (IOException | IllegalAccessException writeError) {
                        ALConstants.logError(writeError, "Failed to rewrite config file", new Object[0]);
                    }
                }
                catch (IllegalStateException e) {
                    if (e.getMessage().contains("greater than the maximum") || e.getMessage().contains("less than the minimum")) {
                        ALConstants.logError("Invalid config value detected: {}. Resetting to defaults and recreating config.", e.getMessage());
                        LOCATOR_THREADS = 1;
                        try {
                            SparkConfig.write(configFile, AsyncLocatorConfigFabric.class);
                            ALConstants.logInfo("Config file rewrite with default values", new Object[0]);
                        }
                        catch (IOException | IllegalAccessException writeError) {
                            ALConstants.logError(writeError, "Failed to rewrite cpnfig file", new Object[0]);
                        }
                        break block12;
                    }
                    ALConstants.logError(e, "Failed to read config file, using defaults", new Object[0]);
                    AsyncLocatorConfigFabric.resetToDefaults();
                }
                catch (IOException | IllegalAccessException e) {
                    ALConstants.logError(e, "Failed to read config file {}, using defaults", configFile);
                    AsyncLocatorConfigFabric.resetToDefaults();
                }
            } else {
                ALConstants.logInfo("No config file found - creating it", new Object[0]);
                try {
                    SparkConfig.write(configFile, AsyncLocatorConfigFabric.class);
                }
                catch (IOException | IllegalAccessException e) {
                    ALConstants.logError(e, "Failed to write config file {}", configFile);
                }
            }
        }
    }

    @SparkConfig.Category(value="Feature Toggles")
    public static class FeatureToggles {
        @SparkConfig.Config(value="dolphinTreasureEnabled", comment="If true, enables asynchronous locating of structures for dolphin treasures.")
        public static boolean DOLPHIN_TREASURE_ENABLED = true;
        @SparkConfig.Config(value="eyeOfEnderEnabled", comment="If true, enables asynchronous locating of structures when Eyes Of Ender are thrown.")
        public static boolean EYE_OF_ENDER_ENABLED = true;
        @SparkConfig.Config(value="explorationMapEnabled", comment="If true, enables asynchronous locating of structures for exploration maps found in chests.")
        public static boolean EXPLORATION_MAP_ENABLED = true;
        @SparkConfig.Config(value="locateCommandEnabled", comment="If true, enables asynchronous locating of structures for the locate command.")
        public static boolean LOCATE_COMMAND_ENABLED = true;
        @SparkConfig.Config(value="villagerTradeEnabled", comment="If true, enables asynchronous locating of structures for villager trades.")
        public static boolean VILLAGER_TRADE_ENABLED = true;
    }
}

