/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.mixins;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.AsyncLocator;
import brightspark.asynclocator.platform.Services;
import net.minecraft.class_1433;
import net.minecraft.class_2338;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_6862;
import net.minecraft.class_7045;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(targets={"net.minecraft.world.entity.animal.Dolphin$DolphinSwimToTreasureGoal"}, priority=800)
public class DolphinSwimToTreasureGoalMixin {
    private AsyncLocator.LocateTask<class_2338> locateTask = null;
    private class_2338 asyncFoundPos = null;

    @Redirect(method={"start"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;findNearestMapStructure(Lnet/minecraft/tags/TagKey;Lnet/minecraft/core/BlockPos;IZ)Lnet/minecraft/core/BlockPos;"))
    public class_2338 redirectFindNearestMapStructure(class_3218 level, class_6862<class_3195> structureTag, class_2338 pos, int searchRadius, boolean skipKnownStructures) {
        if (!Services.CONFIG.dolphinTreasureEnabled()) {
            return level.method_8487(structureTag, pos, searchRadius, skipKnownStructures);
        }
        ALConstants.logDebug("Intercepted DolphinSwimToTreasureGoal findNearestMapStructure call", new Object[0]);
        this.asyncFoundPos = null;
        this.handleFindTreasureAsync(level, pos);
        return null;
    }

    @Inject(method={"canContinueToUse"}, at={@At(value="HEAD")}, cancellable=true)
    public void continueToUseIfLocatingTreasure(CallbackInfoReturnable<Boolean> cir) {
        if (this.locateTask != null || this.asyncFoundPos != null) {
            cir.setReturnValue((Object)true);
        }
    }

    @Inject(method={"stop"}, at={@At(value="HEAD")})
    public void stopLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null) {
            ALConstants.logDebug("Locating task ongoing - cancelling during stop()", new Object[0]);
            this.locateTask.cancel();
            this.locateTask = null;
        }
        this.asyncFoundPos = null;
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")}, cancellable=true)
    public void skipTickingIfLocatingTreasure(CallbackInfo ci) {
        if (this.locateTask != null && this.asyncFoundPos == null) {
            ci.cancel();
        }
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/animal/Dolphin;getTreasurePos()Lnet/minecraft/core/BlockPos;"))
    public class_2338 redirectGetTreasurePos(class_1433 dolphin) {
        if (this.asyncFoundPos != null) {
            return this.asyncFoundPos;
        }
        return dolphin.method_6494();
    }

    private void handleFindTreasureAsync(class_3218 level, class_2338 blockPos) {
        this.locateTask = AsyncLocator.locate(level, (class_6862<class_3195>)class_7045.field_37041, blockPos, 50, false).thenOnServerThread(pos -> this.handleLocationFound(level, (class_2338)pos));
    }

    private void handleLocationFound(class_3218 level, class_2338 pos) {
        this.locateTask = null;
        this.asyncFoundPos = pos;
        if (pos != null) {
            ALConstants.logInfo("Location found at {} - dolphin will now swim to treasure", pos);
        } else {
            ALConstants.logInfo("No location found - dolphin will continue normal behavior", new Object[0]);
        }
    }
}

