/*
 * Decompiled with CFR 0.152.
 */
package brightspark.asynclocator.platform;

import brightspark.asynclocator.ALConstants;
import brightspark.asynclocator.logic.CommonLogic;
import brightspark.asynclocator.platform.services.ExplorationMapFunctionLogicHelper;
import java.util.UUID;
import java.util.function.BiConsumer;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_9428;
import org.jetbrains.annotations.Nullable;

public class FabricExplorationMapFunctionLogicHelper
implements ExplorationMapFunctionLogicHelper {
    @Override
    public void invalidateMap(class_1799 mapStack, class_3218 level, class_2338 invPos) {
        boolean updated = FabricExplorationMapFunctionLogicHelper.handleUpdateMapInContainer(mapStack, level, invPos, (container, slot) -> {
            ALConstants.logDebug("Invalidating map in Fabric container slot {}", slot);
            container.method_5447(slot.intValue(), new class_1799((class_1935)class_1802.field_8895));
        });
        if (!updated) {
            ALConstants.logDebug("Fabric invalidateMap fallback: no container/slot match. Clearing pending state in-place.", new Object[0]);
            CommonLogic.clearPendingState(mapStack);
        }
    }

    @Override
    public void updateMap(class_1799 mapStack, class_3218 level, class_2338 pos, int scale, class_6880<class_9428> destinationTypeHolder, class_2338 invPos, @Nullable class_2561 displayName) {
        boolean updated = FabricExplorationMapFunctionLogicHelper.handleUpdateMapInContainer(mapStack, level, invPos, (container, slot) -> {
            class_1799 actualStack = container.method_5438(slot.intValue());
            CommonLogic.finalizeMap(actualStack, level, pos, scale, destinationTypeHolder, displayName);
            ALConstants.logDebug("Updated map in Fabric container slot {}, broadcasting changes.", slot);
            container.method_5447(slot.intValue(), actualStack);
            CommonLogic.clearPendingState(actualStack);
        });
        if (!updated) {
            ALConstants.logDebug("Fabric updateMap fallback: no container/slot match. Finalizing pending map in-place.", new Object[0]);
            CommonLogic.finalizeMap(mapStack, level, pos, scale, destinationTypeHolder, displayName);
        }
    }

    private static boolean handleUpdateMapInContainer(class_1799 mapStackToFind, class_3218 level, class_2338 inventoryPos, BiConsumer<class_1263, Integer> handleSlotFound) {
        class_2586 be = level.method_8321(inventoryPos);
        if (be instanceof class_1263) {
            class_1263 container = (class_1263)be;
            boolean found = false;
            UUID targetId = CommonLogic.getTrackingUUID(mapStackToFind);
            if (targetId != null) {
                for (int i = 0; i < container.method_5439(); ++i) {
                    class_1799 slotStack = container.method_5438(i);
                    UUID slotId = CommonLogic.getTrackingUUID(slotStack);
                    if (!targetId.equals(slotId)) continue;
                    handleSlotFound.accept(container, i);
                    CommonLogic.broadcastContainerChanges(level, be, container);
                    found = true;
                    break;
                }
            }
            if (!found) {
                ALConstants.logWarn("Could not find map with UUID {} in container {} at {}", targetId, be.getClass().getSimpleName(), inventoryPos);
            }
            return found;
        }
        ALConstants.logWarn("No Container at inventory position {} in level {}", inventoryPos, level.method_27983().method_29177());
        return false;
    }
}

