/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.sage_brush.common.item;

import com.davigj.sage_brush.core.SBConfig;
import com.davigj.sage_brush.core.other.SBBrushUtil;
import com.davigj.sage_brush.core.other.tags.SBBlockTags;
import com.davigj.sage_brush.core.registry.SBSounds;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BrushItem
extends Item {
    public static final int ANIMATION_DURATION = 10;
    private static final int USE_DURATION = 200;
    public static final double MAX_BRUSH_DISTANCE = Math.sqrt(ServerGamePacketListenerImpl.f_215198_) - 1.0;

    public BrushItem(Item.Properties p_272907_) {
        super(p_272907_);
    }

    public InteractionResult m_6225_(UseOnContext p_272607_) {
        Player player = p_272607_.m_43723_();
        if (player != null && this.calculateHitResult((LivingEntity)player).m_6662_() == HitResult.Type.BLOCK) {
            player.m_6672_(p_272607_.m_43724_());
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public InteractionResult m_6880_(@NotNull ItemStack p_41398_, @NotNull Player player, @NotNull LivingEntity p_41400_, InteractionHand hand) {
        if (this.calculateHitResult((LivingEntity)player).m_6662_() == HitResult.Type.ENTITY) {
            player.m_6672_(hand);
        }
        return InteractionResult.CONSUME;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack p_273490_) {
        return UseAnim.CUSTOM;
    }

    public int m_8105_(ItemStack p_272765_) {
        return 200;
    }

    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int duration) {
        Player player;
        HitResult result;
        BrushItem brush = this;
        if (living instanceof Player && (result = this.calculateHitResult((LivingEntity)(player = (Player)living))) instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)result;
            if (result.m_6662_() == HitResult.Type.ENTITY) {
                boolean $$10;
                int $$9 = brush.m_8105_(stack) - duration + 1;
                boolean bl = $$10 = $$9 % 10 == 5;
                if ($$10) {
                    level.m_5594_(player, player.m_20183_(), (SoundEvent)SBSounds.BRUSH_GENERIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    Entity $$11 = ehr.m_82443_();
                    HumanoidArm arm = player.m_7655_() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                    Vec3 vec3 = living.m_20252_(0.0f).m_82490_(MAX_BRUSH_DISTANCE);
                    SBBrushUtil.onEntityUseTick(level, stack, $$11, living, vec3, arm, (HitResult)ehr);
                }
                return;
            }
        }
        if (duration >= 0 && living instanceof Player) {
            player = (Player)living;
            HitResult hitresult = this.calculateHitResult(living);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                    boolean flag;
                    int i = this.m_8105_(stack) - duration + 1;
                    boolean bl = flag = i % 10 == 5;
                    if (flag) {
                        HumanoidArm humanoidarm;
                        BlockPos blockpos = blockhitresult.m_82425_();
                        BlockState blockstate = level.m_8055_(blockpos);
                        HumanoidArm humanoidArm = humanoidarm = living.m_7655_() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                        if (((Boolean)SBConfig.CLIENT.specializedParticles.get()).booleanValue()) {
                            SBBrushUtil.onBlockBrushTick(level, blockhitresult, blockstate, living.m_20252_(0.0f), humanoidarm, blockpos, living, stack);
                        } else {
                            this.spawnDustParticles(level, blockhitresult, blockstate, living.m_20252_(0.0f), humanoidarm);
                        }
                        SoundEvent soundevent = (SoundEvent)SBSounds.BRUSH_GENERIC.get();
                        level.m_5594_(player, blockpos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return;
                }
            }
            living.m_21253_();
        } else {
            living.m_21253_();
        }
    }

    public HitResult calculateHitResult(LivingEntity living) {
        Vec3 vec3 = living.m_20252_(0.0f).m_82490_(MAX_BRUSH_DISTANCE);
        Level level = living.f_19853_;
        Vec3 vec31 = living.m_146892_();
        Predicate<Entity> predicate = entity -> !entity.m_5833_() && entity.m_6087_();
        return SBBrushUtil.getBrushHitResult(vec31, (Entity)living, predicate, vec3, level);
    }

    public static HitResult getHitResultOnViewVector(Entity p_278281_, Predicate<Entity> p_278306_, double p_278293_) {
        Vec3 vec3 = p_278281_.m_20252_(0.0f).m_82490_(p_278293_);
        Level level = p_278281_.f_19853_;
        Vec3 vec31 = p_278281_.m_146892_();
        return BrushItem.getHitResult(vec31, p_278281_, p_278306_, vec3, level);
    }

    private static HitResult getHitResult(Vec3 p_278237_, Entity p_278320_, Predicate<Entity> p_278257_, Vec3 p_278342_, Level p_278321_) {
        EntityHitResult hitresult1;
        Vec3 vec3 = p_278237_.m_82549_(p_278342_);
        BlockHitResult hitresult = p_278321_.m_45547_(new ClipContext(p_278237_, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, p_278320_));
        if (hitresult.m_6662_() != HitResult.Type.MISS) {
            vec3 = hitresult.m_82450_();
        }
        if ((hitresult1 = ProjectileUtil.m_37304_((Level)p_278321_, (Entity)p_278320_, (Vec3)p_278237_, (Vec3)vec3, (AABB)p_278320_.m_20191_().m_82369_(p_278342_).m_82400_(1.0), p_278257_)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    public void spawnDustParticles(Level level, BlockHitResult hitResult, BlockState state, Vec3 p_278337_, HumanoidArm p_285071_) {
        if (((Boolean)SBConfig.CLIENT.gleamingParticles.get()).booleanValue() && state.m_204336_(SBBlockTags.GLEAMING)) {
            SBBrushUtil.gleam(level, hitResult, state, level.m_213780_().m_216339_(1, 3));
            if (((Boolean)SBConfig.CLIENT.purePolish.get()).booleanValue()) {
                return;
            }
        }
        int i = p_285071_ == HumanoidArm.RIGHT ? 1 : -1;
        int j = (Boolean)SBConfig.CLIENT.reducedParticles.get() != false && state.m_204336_(SBBlockTags.REDUCED_DUST) ? level.m_213780_().m_216339_(2, 4) : level.m_213780_().m_216339_(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.f_123794_, state);
        Direction direction = hitResult.m_82434_();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(p_278337_, direction);
        Vec3 vec3 = hitResult.m_82450_();
        for (int k = 0; k < j; ++k) {
            level.m_7106_((ParticleOptions)blockparticleoption, vec3.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.f_82480_, vec3.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)i * 3.0 * level.m_213780_().m_188500_(), 0.0, brushitem$dustparticlesdelta.zd() * (double)i * 3.0 * level.m_213780_().m_188500_());
        }
    }

    public static void spawnStaticDust(Level p_278327_, BlockHitResult p_278272_, BlockState p_278235_, Vec3 p_278337_, HumanoidArm p_285071_) {
        double d0 = 3.0;
        int i = p_285071_ == HumanoidArm.RIGHT ? 1 : -1;
        int j = p_278327_.m_213780_().m_216339_(7, 12);
        BlockParticleOption blockparticleoption = new BlockParticleOption(ParticleTypes.f_123794_, p_278235_);
        Direction direction = p_278272_.m_82434_();
        DustParticlesDelta brushitem$dustparticlesdelta = DustParticlesDelta.fromDirection(p_278337_, direction);
        Vec3 vec3 = p_278272_.m_82450_();
        for (int k = 0; k < j; ++k) {
            p_278327_.m_7106_((ParticleOptions)blockparticleoption, vec3.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), vec3.f_82480_, vec3.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), brushitem$dustparticlesdelta.xd() * (double)i * 3.0 * p_278327_.m_213780_().m_188500_(), 0.0, brushitem$dustparticlesdelta.zd() * (double)i * 3.0 * p_278327_.m_213780_().m_188500_());
        }
    }

    record DustParticlesDelta(double xd, double yd, double zd) {
        private static final double ALONG_SIDE_DELTA = 1.0;
        private static final double OUT_FROM_SIDE_DELTA = 0.1;

        public static DustParticlesDelta fromDirection(Vec3 p_273421_, Direction p_272987_) {
            double d0 = 0.0;
            return switch (p_272987_) {
                case Direction.DOWN, Direction.UP -> new DustParticlesDelta(p_273421_.m_7094_(), 0.0, -p_273421_.m_7096_());
                case Direction.NORTH -> new DustParticlesDelta(1.0, 0.0, -0.1);
                case Direction.SOUTH -> new DustParticlesDelta(-1.0, 0.0, 0.1);
                case Direction.WEST -> new DustParticlesDelta(-0.1, 0.0, -1.0);
                case Direction.EAST -> new DustParticlesDelta(0.1, 0.0, 1.0);
                default -> throw new IncompatibleClassChangeError();
            };
        }
    }
}

