/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.sage_brush.common.item;

import com.davigj.sage_brush.client.BrushDustParticleOptions;
import com.davigj.sage_brush.common.item.BrushItem;
import com.davigj.sage_brush.core.registry.SBSounds;
import com.mojang.math.Vector3f;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class DyeBrushItem
extends BrushItem {
    private final DyeColor color;

    public DyeBrushItem(Item.Properties p_272907_, DyeColor color) {
        super(p_272907_);
        this.color = color;
    }

    @Override
    public void m_5929_(Level level, LivingEntity living, ItemStack stack, int duration) {
        Player player;
        HitResult result;
        if (living instanceof Player && (result = this.calculateHitResult((LivingEntity)(player = (Player)living))) instanceof EntityHitResult) {
            EntityHitResult ehr = (EntityHitResult)result;
            if (result.m_6662_() == HitResult.Type.ENTITY) {
                boolean $$10;
                int $$9 = this.m_8105_(stack) - duration + 1;
                boolean bl = $$10 = $$9 % 10 == 5;
                if ($$10) {
                    level.m_5594_(player, player.m_20183_(), (SoundEvent)SBSounds.BRUSH_GENERIC.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    Entity $$11 = ehr.m_82443_();
                    HumanoidArm arm = player.m_7655_() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                    Vec3 vec3 = living.m_20252_(0.0f).m_82490_(MAX_BRUSH_DISTANCE);
                    this.entityDustParticleFX(level, $$11, vec3, arm, this.getColor());
                }
                return;
            }
        }
        if (duration >= 0 && living instanceof Player) {
            player = (Player)living;
            HitResult hitresult = this.calculateHitResult(living);
            if (hitresult instanceof BlockHitResult) {
                BlockHitResult blockhitresult = (BlockHitResult)hitresult;
                if (hitresult.m_6662_() == HitResult.Type.BLOCK) {
                    boolean flag;
                    int i = this.m_8105_(stack) - duration + 1;
                    boolean bl = flag = i % 10 == 5;
                    if (flag) {
                        BlockPos blockpos = blockhitresult.m_82425_();
                        BlockState blockstate = level.m_8055_(blockpos);
                        HumanoidArm humanoidarm = living.m_7655_() == InteractionHand.MAIN_HAND ? player.m_5737_() : player.m_5737_().m_20828_();
                        this.onBlockBrushTick(level, blockhitresult, blockstate, living.m_20252_(0.0f), humanoidarm, blockpos, living, stack);
                        this.blockDustParticleFX(level, blockhitresult, living.m_20252_(0.0f), humanoidarm, this.getColor());
                        SoundEvent soundevent = (SoundEvent)SBSounds.BRUSH_GENERIC.get();
                        level.m_5594_(player, blockpos, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    return;
                }
            }
            living.m_21253_();
        } else {
            living.m_21253_();
        }
    }

    private void entityDustParticleFX(Level level, Entity victim, Vec3 vec3, HumanoidArm arm, DyeColor dye) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.m_213780_().m_216339_(1, 4);
        Vec3 pos = victim.m_146892_();
        vec3 = vec3.m_82541_();
        for (int k = 0; k < j; ++k) {
            double dx = vec3.m_7094_() * (double)i * 0.07 * level.m_213780_().m_188500_();
            double dz = -vec3.m_7096_() * (double)i * 0.07 * level.m_213780_().m_188500_();
            level.m_7106_((ParticleOptions)new BrushDustParticleOptions(new Vector3f(Vec3.m_82501_((int)dye.m_41070_())), 1.0f), pos.f_82479_, victim.f_19855_ + (double)(victim.m_20206_() / 2.0f), pos.f_82481_, dx, 0.0, dz);
        }
    }

    private void blockDustParticleFX(Level level, BlockHitResult hitResult, Vec3 vec3, HumanoidArm arm, DyeColor color) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.m_213780_().m_216339_(1, 4);
        Direction direction = hitResult.m_82434_();
        Vec3 pos = hitResult.m_82450_();
        vec3 = vec3.m_82490_(0.1);
        for (int k = 0; k < j; ++k) {
            level.m_7106_((ParticleOptions)new BrushDustParticleOptions(new Vector3f(Vec3.m_82501_((int)color.m_41070_())), 1.0f), pos.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), pos.f_82480_, pos.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), vec3.m_7094_() * (double)i * 3.0 * level.m_213780_().m_188500_(), 0.0, -vec3.m_7096_() * (double)i * 3.0 * level.m_213780_().m_188500_());
        }
    }

    public void onBlockBrushTick(Level level, BlockHitResult hitResult, BlockState state, Vec3 velocity, HumanoidArm arm, BlockPos blockPos, LivingEntity living, ItemStack stack) {
        System.out.println(((Block)state.m_222976_().get()).m_49954_());
    }

    public DyeColor getColor() {
        return this.color;
    }

    public int m_142159_(@NotNull ItemStack p_150901_) {
        return this.getColor().m_41070_();
    }

    private static Supplier<Block> getConversionBlock(String fullId) {
        String[] parts = fullId.split(":");
        if (parts.length != 2) {
            return () -> Blocks.f_50723_;
        }
        String modid = parts[0];
        String blockID = parts[1];
        if (!ModList.get().isLoaded(modid) && modid != null) {
            return () -> Blocks.f_50723_;
        }
        assert (modid != null);
        ResourceLocation block = new ResourceLocation(modid, blockID);
        if (ForgeRegistries.BLOCKS.getValue(block) == Blocks.f_50016_) {
            return () -> Blocks.f_50723_;
        }
        return ModList.get().isLoaded(modid) ? () -> (Block)ForgeRegistries.BLOCKS.getValue(block) : () -> null;
    }
}

