/*
 * Decompiled with CFR 0.152.
 */
package com.davigj.sage_brush.core.other;

import com.davigj.sage_brush.client.BrushDustParticleOptions;
import com.davigj.sage_brush.common.item.BrushItem;
import com.davigj.sage_brush.core.SBConfig;
import com.davigj.sage_brush.core.SageBrush;
import com.davigj.sage_brush.core.other.SBConstants;
import com.davigj.sage_brush.core.other.tags.SBBlockTags;
import com.davigj.sage_brush.core.other.tags.SBEntityTypeTags;
import com.davigj.sage_brush.core.registry.SBParticleTypes;
import com.mojang.math.Vector3f;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedData;
import com.teamabnormals.blueprint.common.world.storage.tracking.TrackedDataManager;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Shearable;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Parrot;
import net.minecraft.world.entity.animal.Turtle;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fml.ModList;

public class SBBrushUtil {
    public static final TrackedDataManager manager = TrackedDataManager.INSTANCE;

    public static void onEntityUseTick(Level level, ItemStack stack, Entity victim, LivingEntity player, Vec3 velocity, HumanoidArm arm, HitResult result) {
        int timer;
        int timer2;
        TamableAnimal tamable;
        if (!(victim.m_20071_() || victim.m_6095_().m_204039_(SBEntityTypeTags.SLIMY) || victim.m_6095_().m_204039_(SBEntityTypeTags.FEATHERED) || victim.m_6095_().m_204039_(SBEntityTypeTags.COSMETIC_FEATHERED) || !((Boolean)SBConfig.CLIENT.allFeathersNoDust.get()).booleanValue())) {
            SBBrushUtil.entityDustParticleFX(level, victim, velocity, arm, 1, 4, result);
        }
        if (victim instanceof TamableAnimal && (tamable = (TamableAnimal)victim).m_21830_(player)) {
            if (level.f_46443_ && ((Boolean)SBConfig.CLIENT.petHearts.get()).booleanValue()) {
                SBBrushUtil.entityParticleFX(level, (Entity)tamable, velocity, arm, (ParticleOptions)ParticleTypes.f_123750_, 0, 2);
            } else if (tamable.m_217043_().m_188500_() < 0.2 && ((Boolean)SBConfig.COMMON.regen.get()).booleanValue()) {
                tamable.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 60));
                SBBrushUtil.damageItem(stack, player);
            }
        }
        if (victim instanceof Panda) {
            Panda panda = (Panda)victim;
            double achoo = panda.m_217043_().m_188500_();
            if (achoo > 0.85) {
                if ((panda.m_6162_() || panda.m_29164_() || !((Boolean)SBConfig.COMMON.weakAndSick.get()).booleanValue()) && panda.m_29167_() && !panda.m_29149_() && ((Boolean)SBConfig.COMMON.pandaSneeze.get()).booleanValue()) {
                    panda.m_29220_(true);
                    SBBrushUtil.damageItem(stack, player);
                }
                if (!panda.m_29163_() && !panda.m_29161_() || !((Boolean)SBConfig.COMMON.lazyAndPlayful.get()).booleanValue()) {
                    SBBrushUtil.snagBrush((LivingEntity)panda, player, 1.0 - achoo, (Double)SBConfig.COMMON.pandaSnagChance.get());
                }
            }
            return;
        }
        if (victim.m_6095_().m_204039_(SBEntityTypeTags.FEATHERED) || victim.m_6095_().m_204039_(SBEntityTypeTags.WORSE_FEATHERED) || victim.m_6095_().m_204039_(SBEntityTypeTags.COSMETIC_FEATHERED)) {
            if (level.f_46443_ && ((Boolean)SBConfig.CLIENT.molt.get()).booleanValue()) {
                SBBrushUtil.visualMoltFX(level, victim, velocity, arm);
            } else if (((Boolean)SBConfig.COMMON.featheredMolt.get()).booleanValue()) {
                if (victim.m_6095_().m_204039_(SBEntityTypeTags.FEATHERED)) {
                    SBBrushUtil.pluck(stack, player, victim, SageBrush.FEATHER_TIMER, (Integer)SBConfig.COMMON.moltTimer.get());
                } else if (victim.m_6095_().m_204039_(SBEntityTypeTags.WORSE_FEATHERED)) {
                    SBBrushUtil.pluck(stack, player, victim, SageBrush.WORSE_FEATHER_TIMER, (Integer)SBConfig.COMMON.worseMoltTimer.get());
                }
                if (victim instanceof LivingEntity) {
                    SBBrushUtil.snagBrush((LivingEntity)victim, player, level.m_213780_().m_188500_(), (Double)SBConfig.COMMON.featherSnagChance.get());
                }
            }
        }
        if (victim instanceof Turtle) {
            Turtle turtle = (Turtle)victim;
            if (((Boolean)SBConfig.COMMON.scute.get()).booleanValue()) {
                int timer3 = (Integer)manager.getValue((Entity)turtle, SageBrush.SCUTE_TIMER);
                if (timer3 == 0) {
                    turtle.m_19998_((ItemLike)Items.f_42355_);
                    SBBrushUtil.damageItem(stack, player);
                    manager.setValue((Entity)turtle, SageBrush.SCUTE_TIMER, (Object)((Integer)SBConfig.COMMON.scuteTimer.get()));
                }
                return;
            }
        }
        if (((Boolean)SBConfig.COMMON.torScute.get()).booleanValue() && ModList.get().isLoaded("sullysmod") && SBConstants.isTortoise(victim) && (timer2 = ((Integer)manager.getValue(victim, SageBrush.SCUTE_TIMER)).intValue()) == 0) {
            victim.m_19998_((ItemLike)SBConstants.tortoiseScute);
            SBBrushUtil.damageItem(stack, player);
            manager.setValue(victim, SageBrush.SCUTE_TIMER, (Object)((Integer)SBConfig.COMMON.torScuteTimer.get()));
        }
        if (((Boolean)SBConfig.COMMON.yakHair.get()).booleanValue() && ModList.get().isLoaded("environmental") && SBConstants.isYak(victim)) {
            if (level.f_46443_) {
                SBBrushUtil.entityParticleFX(level, victim, velocity, arm, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50502_.m_49966_()), 2, 4);
            } else if (victim instanceof Shearable) {
                Shearable shearable = (Shearable)victim;
                if (victim instanceof Animal) {
                    Animal animal = (Animal)victim;
                    if (shearable.m_6220_() && player instanceof Player && animal.m_217043_().m_188499_()) {
                        victim.m_20000_((ItemLike)SBConstants.yakHair, ((Integer)SBConfig.COMMON.yakBrushHairCount.get()).intValue());
                        SBBrushUtil.damageItem(stack, player);
                        if ((double)(2.0f * animal.m_217043_().m_188501_()) < (Double)SBConfig.COMMON.yakShearChance.get()) {
                            if (!(((Boolean)SBConfig.COMMON.yakBrushGentle.get()).booleanValue() || ((Player)player).m_150110_().f_35937_ || player.m_6844_(EquipmentSlot.LEGS).m_150930_(SBConstants.yakPants))) {
                                animal.m_6710_(player);
                            }
                            SBConstants.setSheared((LivingEntity)animal);
                            animal.m_216990_(SoundEvents.f_12344_);
                        }
                    }
                }
            }
        }
        if (victim.m_6095_().m_204039_(SBEntityTypeTags.STRINGABLES) && (timer = ((Integer)manager.getValue(victim, SageBrush.STRING_TIMER)).intValue()) == 0) {
            victim.m_19998_((ItemLike)Items.f_42401_);
            SBBrushUtil.damageItem(stack, player);
            manager.setValue(victim, SageBrush.STRING_TIMER, (Object)((Integer)SBConfig.COMMON.stringTimer.get()));
        }
    }

    private static void visualMoltFX(Level level, Entity victim, Vec3 velocity, HumanoidArm arm) {
        ParticleOptions particle = (ParticleOptions)SBParticleTypes.FEATHER.get();
        if (victim instanceof Parrot) {
            particle = (ParticleOptions)SBParticleTypes.PARROT_FEATHER.get();
        } else if (victim.m_6095_().m_204039_(SBEntityTypeTags.COSMETIC_BLACK_FEATHERS)) {
            particle = (ParticleOptions)SBParticleTypes.BLACK_FEATHER.get();
        } else if (victim.m_6095_().m_204039_(SBEntityTypeTags.COSMETIC_HUMMINGBIRD_FEATHERS)) {
            particle = (ParticleOptions)SBParticleTypes.HUMMINGBIRD_FEATHER.get();
        } else if (victim.m_6095_().m_204039_(SBEntityTypeTags.COSMETIC_ROADRUNNER_FEATHERS)) {
            particle = (ParticleOptions)SBParticleTypes.ROADRUNNER_FEATHER.get();
        } else if (victim.m_6095_().m_204039_(SBEntityTypeTags.COSMETIC_EMU_FEATHERS)) {
            particle = (ParticleOptions)SBParticleTypes.EMU_FEATHER.get();
        } else if (victim.m_6095_().m_204039_(SBEntityTypeTags.COSMETIC_SHOEBILL_FEATHERS)) {
            particle = (ParticleOptions)SBParticleTypes.SHOEBILL_FEATHER.get();
        } else if (victim.m_6095_().m_204039_(SBEntityTypeTags.COSMETIC_SUNBIRD_FEATHERS)) {
            particle = SBConstants.sunbirdParticle;
        }
        SBBrushUtil.entityParticleFX(level, victim, velocity, arm, particle, 1, 3);
    }

    private static void pluck(ItemStack stack, LivingEntity player, Entity pluckee, TrackedData<Integer> timerData, int reset) {
        int timer = (Integer)manager.getValue(pluckee, timerData);
        if (timer == 0) {
            Item item = Items.f_42402_;
            if (ModList.get().isLoaded("alexsmobs")) {
                if (SBConstants.isEmu(pluckee)) {
                    item = SBConstants.emuFeather;
                } else if (SBConstants.isRoadrunner(pluckee)) {
                    item = SBConstants.roadrunnerFeather;
                }
            }
            pluckee.m_19998_((ItemLike)item);
            SBBrushUtil.damageItem(stack, player);
            manager.setValue(pluckee, timerData, (Object)reset);
        }
    }

    private static void snagBrush(LivingEntity victim, LivingEntity perp, double snag, double snagConfig) {
        TamableAnimal tamable;
        if (victim instanceof TamableAnimal && (tamable = (TamableAnimal)victim).m_21830_(perp)) {
            return;
        }
        if (((Boolean)SBConfig.COMMON.brushSnag.get()).booleanValue() && snag < snagConfig) {
            victim.m_5496_(SoundEvents.f_12274_, 0.3f, 1.8f);
            if (((Boolean)SBConfig.COMMON.brushSnagMockDamage.get()).booleanValue()) {
                victim.m_6469_(DamageSource.f_19318_, 0.0f);
            }
            victim.m_6703_(perp);
        }
    }

    private static void entityParticleFX(Level level, Entity victim, Vec3 vec3, HumanoidArm arm, ParticleOptions particle, int minPar, int maxPar) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.m_213780_().m_216339_(minPar, maxPar);
        Vec3 pos = victim.m_146892_();
        vec3 = vec3.m_82490_(0.1);
        for (int k = 0; k < j; ++k) {
            level.m_7106_(particle, pos.f_82479_, pos.f_82480_, pos.f_82481_, vec3.m_7094_() * (double)i * 0.1 * level.m_213780_().m_188500_(), 0.0, -vec3.m_7096_() * (double)i * 0.1 * level.m_213780_().m_188500_());
        }
    }

    private static void entityDustParticleFX(Level level, Entity victim, Vec3 vec3, HumanoidArm arm, int minPar, int maxPar, HitResult result) {
        Item item;
        Mob mob;
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.m_213780_().m_216339_(minPar, maxPar);
        Vec3 pos = victim.m_146892_();
        int color = 0xFFFFFF;
        if (victim instanceof Mob && (mob = (Mob)victim).getPickedResult(result) != null && (item = mob.getPickedResult(result).m_41720_()) instanceof SpawnEggItem) {
            SpawnEggItem egg = (SpawnEggItem)item;
            color = egg.m_43211_(0);
        }
        vec3 = vec3.m_82541_();
        for (int k = 0; k < j; ++k) {
            double dx = vec3.m_7094_() * (double)i * 0.07 * level.m_213780_().m_188500_();
            double dz = -vec3.m_7096_() * (double)i * 0.07 * level.m_213780_().m_188500_();
            level.m_7106_((ParticleOptions)new BrushDustParticleOptions(new Vector3f(Vec3.m_82501_((int)color)), 1.0f), pos.f_82479_, victim.f_19855_ + (double)(victim.m_20206_() / 2.0f), pos.f_82481_, dx, 0.0, dz);
        }
    }

    public static void onBlockBrushTick(Level level, BlockHitResult hitResult, BlockState state, Vec3 velocity, HumanoidArm arm, BlockPos blockPos, LivingEntity living, ItemStack stack) {
        if (SBBrushUtil.letItShnope(level, state, blockPos)) {
            SBBrushUtil.blockParticleFX(level, hitResult, velocity, arm, (ParticleOptions)ParticleTypes.f_175821_, 10, 14);
            SBBrushUtil.damageItem(stack, living);
            return;
        }
        if (state.m_60713_(Blocks.f_152540_)) {
            SBBrushUtil.blockParticleFX(level, hitResult, velocity, arm, (ParticleOptions)SBParticleTypes.SPORE_BLOSSOM.get(), 2, 5);
            return;
        }
        if (state.m_60713_(Blocks.f_50489_)) {
            SBBrushUtil.blockParticleFX(level, hitResult, velocity, arm, (ParticleOptions)ParticleTypes.f_123810_, 2, 5);
            return;
        }
        if (ModList.get().isLoaded("supplementaries") && SBConstants.isFeatherBlock(state)) {
            SBBrushUtil.blockParticleFX(level, hitResult, velocity, arm, (ParticleOptions)SBParticleTypes.FEATHER.get(), 2, 5);
            return;
        }
        if (ModList.get().isLoaded("atmospheric") && SBConstants.isYellowBlossom(state)) {
            SBBrushUtil.blockParticleFX(level, hitResult, velocity, arm, (ParticleOptions)SBParticleTypes.YELLOW_BLOSSOM.get(), 2, 3);
            return;
        }
        if (((Boolean)SBConfig.COMMON.removable.get()).booleanValue() && state.m_204336_(SBBlockTags.REMOVABLE)) {
            SBBrushUtil.blockParticleFX(level, hitResult, velocity, arm, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), 18, 24);
            if (!level.f_46443_) {
                level.m_7471_(blockPos, false);
                SBBrushUtil.damageItem(stack, living);
            }
            return;
        }
        BrushItem.spawnStaticDust(level, hitResult, state, velocity, arm);
    }

    private static boolean letItShnope(Level level, BlockState state, BlockPos blockPos) {
        if (state.m_60713_(Blocks.f_50125_) || state.m_60713_(SBConstants.snow)) {
            if (!level.f_46443_) {
                int layers = (Integer)state.m_61143_((Property)BlockStateProperties.f_61417_);
                if (layers > 1) {
                    level.m_46597_(blockPos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(layers - 1)));
                } else {
                    level.m_7471_(blockPos, false);
                }
            }
            return true;
        }
        if (state.m_60713_(Blocks.f_50127_)) {
            if (!level.f_46443_) {
                level.m_46597_(blockPos, (BlockState)SBConstants.snow.m_49966_().m_61124_((Property)BlockStateProperties.f_61417_, (Comparable)Integer.valueOf(7)));
            }
            return true;
        }
        return false;
    }

    private static void blockParticleFX(Level level, BlockHitResult hitResult, Vec3 vec3, HumanoidArm arm, ParticleOptions particle, int minPar, int maxPar) {
        int i = arm == HumanoidArm.RIGHT ? 1 : -1;
        int j = level.m_213780_().m_216339_(minPar, maxPar);
        Direction direction = hitResult.m_82434_();
        Vec3 pos = hitResult.m_82450_();
        vec3 = vec3.m_82490_(0.1);
        for (int k = 0; k < j; ++k) {
            level.m_7106_(particle, pos.f_82479_ - (double)(direction == Direction.WEST ? 1.0E-6f : 0.0f), pos.f_82480_, pos.f_82481_ - (double)(direction == Direction.NORTH ? 1.0E-6f : 0.0f), vec3.m_7094_() * (double)i * 3.0 * level.m_213780_().m_188500_(), 0.0, -vec3.m_7096_() * (double)i * 3.0 * level.m_213780_().m_188500_());
        }
    }

    private static void damageItem(ItemStack stack, LivingEntity entity) {
        stack.m_41622_(1, entity, e -> {
            EquipmentSlot slot = stack.equals(entity.m_6844_(EquipmentSlot.OFFHAND)) ? EquipmentSlot.OFFHAND : EquipmentSlot.MAINHAND;
            e.m_21166_(slot);
        });
    }

    public static HitResult getBrushHitResult(Vec3 eye, Entity viewer, Predicate<Entity> predicate, Vec3 view, Level level) {
        EntityHitResult hitresult1;
        Vec3 vec3 = eye.m_82549_(view);
        BlockHitResult hitresult = level.m_45547_(new ClipContext(eye, vec3, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, viewer));
        if (hitresult.m_6662_() != HitResult.Type.MISS) {
            vec3 = hitresult.m_82450_();
        }
        if ((hitresult1 = ProjectileUtil.m_37304_((Level)level, (Entity)viewer, (Vec3)eye, (Vec3)vec3, (AABB)viewer.m_20191_().m_82369_(view).m_82400_(1.0), predicate)) != null) {
            hitresult = hitresult1;
        }
        return hitresult;
    }

    public static void gleam(Level level, BlockHitResult hitResult, BlockState state, int particleCount) {
        RandomSource random = level.m_213780_();
        BlockPos blockpos = hitResult.m_82425_();
        VoxelShape voxelShape = state.m_60812_((BlockGetter)level, blockpos);
        AABB bounds = voxelShape.m_83281_() ? new AABB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0) : voxelShape.m_83215_();
        bounds = bounds.m_82386_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_()).m_82400_(0.2);
        double minDistance = 0.15;
        ArrayList<Vec3> spawnedParticles = new ArrayList<Vec3>();
        for (int i = 0; i < particleCount; ++i) {
            Vec3 newParticlePos = null;
            int attempts = 10;
            do {
                double x = bounds.f_82288_ + random.m_188500_() * (bounds.f_82291_ - bounds.f_82288_);
                double y = bounds.f_82289_ + random.m_188500_() * (bounds.f_82292_ - bounds.f_82289_);
                double z = bounds.f_82290_ + random.m_188500_() * (bounds.f_82293_ - bounds.f_82290_);
                Vec3 candidate = new Vec3(x, y, z);
                boolean isValid = spawnedParticles.stream().noneMatch(pos -> pos.m_82554_(candidate) < minDistance);
                if (!isValid) continue;
                newParticlePos = candidate;
                break;
            } while (--attempts > 0);
            if (newParticlePos == null) continue;
            spawnedParticles.add(newParticlePos);
            level.m_7106_((ParticleOptions)SBParticleTypes.GLEAM.get(), newParticlePos.f_82479_, newParticlePos.f_82480_, newParticlePos.f_82481_, 0.0, 0.0, 0.0);
        }
    }
}

