/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaCommandWhitelist;

import com.google.common.reflect.TypeToken;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;

public class CommandWhiteListConfig {
    private static final String CONFIG_FILE = "PandaCommandWhitelist.json";
    private static final List<String> DEFAULT_COMMANDS = Arrays.asList("tell *", "me *", "msg *", "w *");
    private static List<String> whitelistedCommands;

    public static void init() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE);
        if (!configFile.exists()) {
            CommandWhiteListConfig.createDefaultConfig(configFile);
        }
        CommandWhiteListConfig.loadConfig(configFile);
    }

    private static void createDefaultConfig(File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(configFile);
            new GsonBuilder().setPrettyPrinting().create().toJson(DEFAULT_COMMANDS, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig(File configFile) {
        try {
            FileReader reader = new FileReader(configFile);
            Type listType = new TypeToken<ArrayList<String>>(){}.getType();
            List loadedCommands = (List)new Gson().fromJson((Reader)reader, listType);
            reader.close();
            whitelistedCommands = new ArrayList<String>();
            for (String cmd : loadedCommands) {
                if (cmd == null || cmd.trim().isEmpty()) continue;
                whitelistedCommands.add(cmd);
                if (!cmd.endsWith(" *")) continue;
                String commandWithoutWildcard = cmd.substring(0, cmd.length() - 2).trim();
                whitelistedCommands.add(commandWithoutWildcard);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            whitelistedCommands = new ArrayList<String>(DEFAULT_COMMANDS);
        }
    }

    public static List<String> getWhitelistedCommands() {
        return whitelistedCommands != null ? whitelistedCommands : new ArrayList<String>(DEFAULT_COMMANDS);
    }
}

