/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaCommandWhitelist.mixin;

import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.List;
import java.util.stream.Collectors;
import me.TreeOfSelf.PandaCommandWhitelist.CommandWhiteListConfig;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Redirect;

@Mixin(value={class_2170.class})
public class CommandManagerMixin {
    @Unique
    private final List<String> allowedCommands = CommandWhiteListConfig.getWhitelistedCommands().stream().map(cmd -> cmd.split(" ")[0]).collect(Collectors.toList());

    @Redirect(method={"makeTreeForSource"}, at=@At(value="INVOKE", remap=false, target="Lcom/mojang/brigadier/tree/CommandNode;canUse(Ljava/lang/Object;)Z"))
    private boolean canUseRedirection(CommandNode<class_2168> commandNode, Object objSource) {
        class_2168 source = (class_2168)objSource;
        if (source.method_9259(4)) {
            return true;
        }
        if (!(commandNode instanceof LiteralCommandNode)) {
            return commandNode.canUse((Object)source);
        }
        LiteralCommandNode node = (LiteralCommandNode)commandNode;
        return this.allowedCommands.contains(node.getLiteral()) && commandNode.canUse((Object)source);
    }
}

