/*
 * Decompiled with CFR 0.152.
 */
package me.TreeOfSelf.PandaCommandWhitelist;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandWhiteListConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"panda-command-whitelist");
    private static final String CONFIG_FILE = "PandaCommandWhitelist.json";
    private static final List<String> DEFAULT_COMMANDS = Arrays.asList("tell *", "me *", "msg *", "w *");
    private static final String DEFAULT_BLOCKED_MESSAGE = "That command is blocked or doesn't exist.";
    private static List<String> whitelistedCommands;
    private static String blockedMessage;

    public static void init() {
        File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), CONFIG_FILE);
        if (!configFile.exists()) {
            CommandWhiteListConfig.createDefaultConfig(configFile);
        }
        CommandWhiteListConfig.loadConfig(configFile);
    }

    private static void createDefaultConfig(File configFile) {
        try {
            configFile.getParentFile().mkdirs();
            FileWriter writer = new FileWriter(configFile);
            Config defaultConfig = new Config();
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)defaultConfig, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static void loadConfig(File configFile) {
        try {
            Config config;
            FileReader reader = new FileReader(configFile);
            Gson gson = new Gson();
            Object rawJson = gson.fromJson((Reader)reader, Object.class);
            reader.close();
            boolean needsConversion = false;
            if (rawJson instanceof List) {
                List oldCommands = (List)rawJson;
                config = new Config();
                config.commands = new ArrayList<String>(oldCommands);
                config.blockedMessage = DEFAULT_BLOCKED_MESSAGE;
                needsConversion = true;
            } else {
                reader = new FileReader(configFile);
                config = (Config)gson.fromJson((Reader)reader, Config.class);
                reader.close();
                if (config == null) {
                    config = new Config();
                }
            }
            whitelistedCommands = new ArrayList<String>();
            List<String> loadedCommands = config.commands != null ? config.commands : DEFAULT_COMMANDS;
            for (String cmd : loadedCommands) {
                if (cmd == null || cmd.trim().isEmpty()) continue;
                whitelistedCommands.add(cmd);
                if (!cmd.endsWith(" *")) continue;
                String commandWithoutWildcard = cmd.substring(0, cmd.length() - 2).trim();
                whitelistedCommands.add(commandWithoutWildcard);
            }
            String string = blockedMessage = config.blockedMessage != null ? config.blockedMessage : DEFAULT_BLOCKED_MESSAGE;
            if (needsConversion) {
                CommandWhiteListConfig.saveConfig(configFile, config);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            whitelistedCommands = new ArrayList<String>(DEFAULT_COMMANDS);
            blockedMessage = DEFAULT_BLOCKED_MESSAGE;
        }
    }

    private static void saveConfig(File configFile, Config config) {
        try {
            FileWriter writer = new FileWriter(configFile);
            new GsonBuilder().setPrettyPrinting().create().toJson((Object)config, (Appendable)writer);
            writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static List<String> getWhitelistedCommands() {
        return whitelistedCommands != null ? whitelistedCommands : new ArrayList<String>(DEFAULT_COMMANDS);
    }

    public static String getBlockedMessage() {
        return blockedMessage != null ? blockedMessage : DEFAULT_BLOCKED_MESSAGE;
    }

    public static void reload() {
        LOGGER.info("Reloading PandaCommandWhitelist configuration...");
        CommandWhiteListConfig.init();
        LOGGER.info("Configuration reloaded successfully. {} commands whitelisted.", (Object)whitelistedCommands.size());
    }

    public static class Config {
        public List<String> commands = new ArrayList<String>(DEFAULT_COMMANDS);
        public String blockedMessage = "That command is blocked or doesn't exist.";
    }
}

